/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pnuts.compiler.LocalInfo;
import pnuts.compiler.SymbolSet;

class BranchEnv {
    BranchEnv parent;
    ArrayList scopes;
    SymbolSet scope;
    Map symbolToLocalInfo;

    BranchEnv(BranchEnv parent, SymbolSet ss) {
        this.parent = parent;
        this.scopes = new ArrayList();
        this.symbolToLocalInfo = new HashMap();
        this.addBranch(ss);
    }

    void addBranch(SymbolSet ss) {
        this.scope = new SymbolSet(ss);
        this.scopes.add(this.scope);
    }

    void close() {
        if (this.parent != null) {
            this.parent.symbolToLocalInfo.putAll(this.symbolToLocalInfo);
            Iterator it = this.symbolToLocalInfo.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String sym = (String)entry.getKey();
                LocalInfo info = (LocalInfo)entry.getValue();
                this.parent.scope.add(sym, info);
            }
        }
    }

    LocalInfo lookup(String key) {
        LocalInfo info = (LocalInfo)this.symbolToLocalInfo.get(key);
        if (info != null) {
            return info;
        }
        if (this.parent != null) {
            return this.parent.lookup(key);
        }
        return null;
    }

    LocalInfo assoc(String key) {
        LocalInfo info = this.scope.assoc(key);
        if (info != null) {
            return info;
        }
        if (this.parent != null) {
            return this.parent.assoc(key);
        }
        return null;
    }

    void declare(String symbol, int key, int idx) {
        this.scope.add(symbol, key, idx);
        LocalInfo info = this.scope.info[this.scope.count - 1];
        this.symbolToLocalInfo.put(symbol, info);
    }

    void declare(String symbol, int key) {
        this.scope.add(symbol, key);
        LocalInfo info = this.scope.info[this.scope.count - 1];
        this.symbolToLocalInfo.put(symbol, info);
    }
}

