/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.featgen.MultiStepFeatureGenerator;
import tratz.ml.LiblinearModelReader;
import tratz.ml.LinearClassificationModel;
import tratz.semantics.ClassificationBundle;
import tratz.semantics.ModelNameLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleModelsWithFeatureGenerator {
    public static final String OPT_ALPHABET_DIR_PRED = "alphabets";
    public static final String OPT_MODEL_DIR_PRED = "models";
    public static final String OPT_TRIM_FACTOR_PRED = "trimfactor";
    public static final String OPT_WORD_FINDING_RULE_PRED = "wfr";
    public static final String OPT_FER_PRED = "fer";
    public static final String OPT_COMBO_PRED = "comborules";
    public static final String OPT_MODEL_NAME_LOOKUP = "modellookup";
    public static final String OPT_OUTPUT_FILE = "outputfile";

    public static CommandLineOptions createOptions() {
        CommandLineOptions opts = new CommandLineOptions();
        opts.addOption(OPT_ALPHABET_DIR_PRED, "file", "file/directory containing alphabet file(s)");
        opts.addOption(OPT_MODEL_DIR_PRED, "file", "file/directory containing model file(s)");
        opts.addOption(OPT_TRIM_FACTOR_PRED, "double", "factor to trim model file(s) by");
        opts.addOption(OPT_WORD_FINDING_RULE_PRED, "file", "file containing the word-finding rules for feature generation");
        opts.addOption(OPT_FER_PRED, "file", "file containing the feature extraction rules for feature generation");
        opts.addOption(OPT_COMBO_PRED, "file", "file containing the combination rules for feature generation");
        opts.addOption(OPT_MODEL_NAME_LOOKUP, "string", "name of the class implementing " + ModelNameLookup.class.getCanonicalName() + " for looking up the model name");
        opts.addOption(OPT_OUTPUT_FILE, "file", "file to contain the GZipped wrapper file");
        return opts;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(BundleModelsWithFeatureGenerator.createOptions(), args);
        String alphabets = cmdLine.getStringValue(OPT_ALPHABET_DIR_PRED);
        String models = cmdLine.getStringValue(OPT_MODEL_DIR_PRED);
        double trimFactor = cmdLine.getDoubleValue(OPT_TRIM_FACTOR_PRED);
        String wordFindingRules = cmdLine.getStringValue(OPT_WORD_FINDING_RULE_PRED);
        String ferRules = cmdLine.getStringValue(OPT_FER_PRED);
        String comboRules = cmdLine.getStringValue(OPT_COMBO_PRED);
        String modelLookupClassName = cmdLine.getStringValue(OPT_MODEL_NAME_LOOKUP);
        String outputFile = cmdLine.getStringValue(OPT_OUTPUT_FILE);
        MultiStepFeatureGenerator featureGenerator = new MultiStepFeatureGenerator(wordFindingRules, ferRules, comboRules);
        LinearClassificationModel singleModel = null;
        Map<String, LinearClassificationModel> modelMap = null;
        ClassificationBundle bundle = null;
        ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(outputFile)));
        File modelsFile = new File(models);
        if (modelsFile.isDirectory()) {
            ModelNameLookup modelNameLookup = (ModelNameLookup)Class.forName(modelLookupClassName).newInstance();
            modelMap = BundleModelsWithFeatureGenerator.createModels(new File(models).listFiles(), alphabets, trimFactor);
            bundle = new ClassificationBundle(featureGenerator, modelMap, modelNameLookup);
        } else {
            File alphabetFile = new File(alphabets);
            LinearClassificationModel model = LiblinearModelReader.readLiblinearModel(modelsFile.getAbsolutePath(), alphabetFile.getAbsolutePath());
            singleModel = model.createTrimmedModel((float)trimFactor);
            bundle = new ClassificationBundle(featureGenerator, singleModel);
        }
        System.err.println("Writing: " + outputFile);
        out.writeObject(bundle);
        out.close();
    }

    private static Map<String, LinearClassificationModel> createModels(File[] files, String alphabetDir, double trimFactor) throws Exception {
        HashMap<String, LinearClassificationModel> predicateModels = new HashMap<String, LinearClassificationModel>();
        for (File modelFile : files) {
            System.err.println("Processing: " + modelFile.getAbsolutePath());
            String predicateType = modelFile.getName().substring(0, modelFile.getName().indexOf(".model"));
            File alphabetFile = new File(alphabetDir, predicateType);
            LinearClassificationModel model = LiblinearModelReader.readLiblinearModel(modelFile.getAbsolutePath(), alphabetFile.getAbsolutePath());
            LinearClassificationModel trimmedModel = model.createTrimmedModel((float)trimFactor);
            predicateModels.put(predicateType, trimmedModel);
        }
        return predicateModels;
    }
}

