/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import pnuts.compiler.ClassFile;
import pnuts.compiler.Frame;
import pnuts.compiler.Label;
import pnuts.compiler.LocalInfo;

final class Reference {
    String symbol;
    int index;
    int offset;
    boolean initialized;
    Frame frame;

    Reference(String symbol, int index, int offset) {
        this(symbol, index, offset, false);
    }

    Reference(String symbol, int index, int offset, boolean initialized) {
        this.symbol = symbol;
        this.index = index;
        this.offset = offset;
        this.initialized = initialized;
    }

    Reference(String symbol, int index, int offset, boolean initialized, Frame frame) {
        this.symbol = symbol;
        this.index = index;
        this.offset = offset;
        this.initialized = initialized;
        this.frame = frame;
    }

    Reference(String symbol, LocalInfo info) {
        this(symbol, info.map, info.index, info.initialized, info.frame);
    }

    void set(ClassFile cf, int tgt) {
        if (this.index >= 0) {
            if (this.offset < 0) {
                cf.loadLocal(tgt);
                cf.storeLocal(this.index);
            } else {
                if (!this.initialized) {
                    cf.loadLocal(this.index);
                    Label cont = cf.getLabel();
                    cf.add((byte)-57, cont);
                    cf.add((byte)4);
                    cf.add((byte)-67, "java.lang.Object");
                    cf.storeLocal(this.index);
                    cont.fix();
                }
                cf.loadLocal(this.index);
                cf.pushInteger(this.offset);
                cf.loadLocal(tgt);
                cf.add((byte)83);
            }
        } else {
            cf.add((byte)42);
            cf.add((byte)-76, cf.getClassName(), this.symbol, "[Ljava/lang/Object;");
            cf.pushInteger(this.offset);
            cf.loadLocal(tgt);
            cf.add((byte)83);
        }
    }

    void get(ClassFile cf, boolean local, int contextIndex) {
        if (this.index >= 0) {
            if (this.offset < 0) {
                cf.loadLocal(this.index);
            } else if (local && !this.initialized) {
                cf.loadLocal(this.index);
                Label cont = cf.getLabel();
                Label next = cf.getLabel();
                cf.add((byte)-57, cont);
                cf.loadLocal(contextIndex);
                cf.add((byte)18, cf.addConstant(this.symbol));
                cf.add((byte)-74, "pnuts.lang.Context", "getId", "(Ljava/lang/String;)", "Ljava/lang/Object;");
                cf.add((byte)-89, next);
                cont.fix();
                cf.loadLocal(this.index);
                cf.pushInteger(this.offset);
                cf.add((byte)50);
                next.fix();
            } else {
                cf.loadLocal(this.index);
                cf.pushInteger(this.offset);
                cf.add((byte)50);
            }
        } else {
            cf.add((byte)42);
            cf.add((byte)-76, cf.getClassName(), this.symbol, "[Ljava/lang/Object;");
            if (local && !this.initialized) {
                Label next = cf.getLabel();
                Label cont = cf.getLabel();
                cf.add((byte)-57, cont);
                cf.loadLocal(contextIndex);
                cf.add((byte)18, cf.addConstant(this.symbol));
                cf.add((byte)-74, "pnuts.lang.Context", "getId", "(Ljava/lang/String;)", "Ljava/lang/Object;");
                cf.add((byte)-89, next);
                cont.fix();
                cf.stackTop = (short)(cf.stackTop - 1);
                cf.add((byte)42);
                cf.add((byte)-76, cf.getClassName(), this.symbol, "[Ljava/lang/Object;");
                if (this.offset >= 0) {
                    cf.pushInteger(this.offset);
                    cf.add((byte)50);
                }
                next.fix();
            } else if (this.offset >= 0) {
                cf.pushInteger(this.offset);
                cf.add((byte)50);
            }
        }
    }

    public int hashCode() {
        return (this.symbol.hashCode() * 31 + this.index) * 31 + this.offset;
    }

    public boolean equals(Object object) {
        if (object instanceof Reference) {
            Reference r = (Reference)object;
            if ((this.symbol == null && this.symbol == r.symbol || this.symbol != null && this.symbol.equals(r.symbol)) && this.index == r.index && this.offset == r.offset) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.symbol + "," + this.index + "," + this.offset + "," + this.initialized + "," + this.frame + "]";
    }
}

