/*
 * Decompiled with CFR 0.152.
 */
package Jet.Concepts;

import Jet.Concepts.Word;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Concept
extends DefaultMutableTreeNode
implements Transferable {
    protected Vector subconcepts = new Vector();
    protected Vector words = new Vector();
    public static final DataFlavor DEFAULT_MUTABLE_TREENODE_FLAVOR = new DataFlavor(DefaultMutableTreeNode.class, "Default Mutable Tree Node");
    static DataFlavor[] flavors = new DataFlavor[]{DEFAULT_MUTABLE_TREENODE_FLAVOR};

    public Concept(Object object) {
        super(object, true);
    }

    public String getName() {
        return (String)super.getUserObject();
    }

    public boolean isLeaf() {
        return false;
    }

    public Vector getSubconcepts() {
        return this.subconcepts;
    }

    public Vector getWords() {
        return this.words;
    }

    public int getSubconceptCount() {
        return this.subconcepts.size();
    }

    public int getWordCount() {
        return this.words.size();
    }

    public Concept getSubconceptAt(int n) {
        return (Concept)this.subconcepts.get(n);
    }

    public Word getWordAt(int n) {
        return (Word)this.words.get(n);
    }

    public void addConcept(Concept concept) {
        super.add(concept);
        this.subconcepts.add(concept);
    }

    public void addWord(Word word) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(this.words.size(), word);
        this.words.add(word);
    }

    public void removeConcept(Concept concept) {
        super.remove(concept);
        this.subconcepts.remove(concept);
    }

    public void removeWord(Word word) {
        super.remove(word);
        this.words.remove(word);
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.subconcepts.clear();
        this.words.clear();
    }

    public Enumeration breadthFirstEnumerationOfConcepts() {
        TreeNode treeNode = null;
        Vector<TreeNode> vector = new Vector<TreeNode>();
        Enumeration<TreeNode> enumeration = super.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            treeNode = enumeration.nextElement();
            if (!(treeNode instanceof Concept)) continue;
            vector.add(treeNode);
        }
        return vector.elements();
    }

    public Enumeration breadthFirstEnumerationOfWords() {
        TreeNode treeNode = null;
        Vector<TreeNode> vector = new Vector<TreeNode>();
        Enumeration<TreeNode> enumeration = super.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            treeNode = enumeration.nextElement();
            if (!(treeNode instanceof Word)) continue;
            vector.add(treeNode);
        }
        return vector.elements();
    }

    public Object getTransferData(DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        if (dataFlavor.equals(flavors[0])) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!dataFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

