/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import AceJet.Ace;
import AceJet.EDTtype;
import Jet.Console;
import Jet.Control;
import Jet.JetTest;
import Jet.Pat.Pat;
import Jet.Refres.CorefFilter;
import Jet.Refres.CorefScorer;
import Jet.Refres.DocumentScorer;
import Jet.Refres.PronounScorer;
import Jet.Refres.Resolve;
import Jet.Tipster.CollectionView;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Validate;
import java.io.IOException;

public class CorefEval {
    static final String collection = "coref/training nwire sgm.txt";
    static final String keyCollection = "coref/training nwire coref.txt";
    static final String parseCollection = "coref/training nwire parses.txt";
    static final String baselineCollection = "temp/coref/coref baseline.txt";
    static final boolean writeBaseline = false;
    static final boolean compareToBaseline = false;
    static final boolean useParser = true;
    static final boolean useParseCollection = true;
    static final boolean onlyPronouns = true;

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace 05 use parses.properties");
        new Console();
        EDTtype.readTypeDict();
        Pat.trace = false;
        Resolve.trace = false;
        Resolve.ACE = true;
        Resolve.useMaxEnt = true;
        DocumentCollection documentCollection = new DocumentCollection(parseCollection);
        DocumentCollection documentCollection2 = new DocumentCollection(keyCollection);
        documentCollection.open();
        documentCollection2.open();
        PronounScorer pronounScorer = new PronounScorer();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            Console.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.open();
            Ace.monocase = Ace.allLowerCase(externalDocument);
            Control.processDocument(externalDocument, null, i == -1, i);
            Ace.tagReciprocalRelations(externalDocument);
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setAllTags(true);
            externalDocument2.open();
            externalDocument2.stretch("mention");
            CorefFilter.buildEntitiesFromMentions(externalDocument2);
            ((DocumentScorer)pronounScorer).score(externalDocument, externalDocument2);
            ((DocumentScorer)pronounScorer).report();
        }
        ((DocumentScorer)pronounScorer).summary();
        new CollectionView(documentCollection);
    }

    public static void task(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("CorefEval requires 2 arguments: jet -CorefEval <response collection> <key collection>");
            System.exit(1);
        }
        String string = stringArray[1];
        String string2 = stringArray[2];
        DocumentCollection documentCollection = new DocumentCollection(string);
        DocumentCollection documentCollection2 = new DocumentCollection(string2);
        documentCollection.open();
        documentCollection2.open();
        CorefScorer corefScorer = new CorefScorer();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.open();
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setAllTags(true);
            externalDocument2.open();
            CorefFilter.buildEntitiesFromMentions(externalDocument);
            CorefFilter.buildEntitiesFromMentions(externalDocument2);
            corefScorer.score(externalDocument, externalDocument2);
            corefScorer.report();
        }
        corefScorer.summary();
        float f = 2.0f / (1.0f / corefScorer.overallRecall + 1.0f / corefScorer.overallPrecision);
        Validate.score = f;
    }
}

