/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import Jet.Parser.DepTransformer;
import Jet.Parser.SyntacticRelation;
import Jet.Parser.SyntacticRelationSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import tratz.parse.FullSystemWrapper;
import tratz.parse.types.Arc;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;

public class DepParser {
    private static FullSystemWrapper fsw = null;
    static DepTransformer transformer = null;
    static String[] SPECIAL_TOKEN = new String[]{"ENAMEX", "NUMEX", "TIMEX", "TIMEX2"};

    public static void initialize(String string, Properties properties) {
        String string2 = properties.getProperty("DepParser.model.fileName");
        if (string2 != null) {
            DepParser.initWrapper(string + "/" + string2);
            transformer = new DepTransformer(properties.getProperty("DepParser.transformations"));
        }
    }

    private static void initWrapper(String string) {
        DepParser.initWrapper(null, null, null, null, null, null, string, null);
    }

    private static void initWrapper(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (fsw == null) {
            try {
                fsw = new FullSystemWrapper(string, string2, string3, string4, string5, string6, string7, string8);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public static boolean isInitialized() {
        return fsw != null;
    }

    public static SyntacticRelationSet parseDocument(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("sentence");
        if (vector == null || vector.size() == 0) {
            System.out.println("DepParser:  no sentences");
            return null;
        }
        if (fsw == null) {
            System.out.println("DepParser:  no model loaded");
            return null;
        }
        SyntacticRelationSet syntacticRelationSet = new SyntacticRelationSet();
        for (Annotation annotation : vector) {
            Span span = annotation.span();
            DepParser.parseSentence(document, span, syntacticRelationSet);
        }
        return syntacticRelationSet;
    }

    public static void parseSentence(Document document, Span span, SyntacticRelationSet syntacticRelationSet) {
        List<Arc> list;
        Object object2;
        if (fsw == null) {
            System.out.println("DepParser:  no model loaded");
            return;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(0);
        int n = 0;
        int n2 = span.start();
        while (n2 < span.end()) {
            String string2;
            ++n;
            object2 = document.tokenAt(n2);
            for (String string2 : SPECIAL_TOKEN) {
                Vector<Annotation> vector = document.annotationsAt(n2, string2);
                if (vector == null || vector.size() <= 0) continue;
                object2 = vector.get(0);
                break;
            }
            if (object2 == null) {
                return;
            }
            String object = document.normalizedText((Annotation)object2).replaceAll(" ", "_");
            list = document.annotationsAt(n2, "tagger");
            Annotation annotation = (Annotation)((Vector)list).get(0);
            string2 = (String)annotation.get("cat");
            arrayList.add(new Token(object, string2, n));
            arrayList2.add(n2);
            n2 = ((Annotation)object2).end();
        }
        object2 = new Sentence(arrayList);
        Arc[] arcArray = fsw.process((Sentence)object2, arrayList.size() > 0 && ((Token)arrayList.get(0)).getPos() == null, true, true, true, true, true).getParse().getHeadArcs();
        list = transformer.transform(arcArray, (Sentence)object2);
        for (Arc arc : arcArray) {
            if (arc == null || arc.getDependency().equalsIgnoreCase("ROOT")) continue;
            Token token = arc.getHead();
            String string = token.getText();
            String string3 = token.getPos();
            Integer n3 = (Integer)arrayList2.get(token.getIndex());
            Token token2 = arc.getChild();
            String string4 = token2.getText();
            String string5 = token2.getPos();
            Integer n4 = (Integer)arrayList2.get(token2.getIndex());
            String string6 = arc.getDependency();
            SyntacticRelation syntacticRelation = new SyntacticRelation(n3, string, string3, string6, n4, string4, string5);
            syntacticRelationSet.add(syntacticRelation);
        }
    }
}

