/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.NE.ClassHierarchyResolver;
import Jet.NE.ExactMatchClassHierarchyResolver;
import Jet.NE.RuleFormatException;
import Jet.NE.TransformRule;
import Jet.NE.TransformRuleParser;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformRules {
    private List<TransformRule> rules;
    private ClassHierarchyResolver resolver;

    public TransformRules(List<TransformRule> list, ClassHierarchyResolver classHierarchyResolver) {
        this.rules = list;
        this.resolver = classHierarchyResolver;
    }

    public TransformRules(List<TransformRule> list) {
        this.rules = list;
        this.resolver = new ExactMatchClassHierarchyResolver();
    }

    public void apply(Document document, Span span) {
        Vector<Annotation> vector = document.annotationsOfType("NE_INTERNAL", span);
        Annotation[] annotationArray = vector.toArray(new Annotation[0]);
        block0: for (int i = 0; i < annotationArray.length; ++i) {
            for (TransformRule transformRule : this.rules) {
                if (i + transformRule.getPatternTokenCount() > annotationArray.length || !transformRule.accept(document, annotationArray, i, this.resolver)) continue;
                transformRule.transform(document, annotationArray, i);
                continue block0;
            }
        }
    }

    public void setClassHierarchyResolver(ClassHierarchyResolver classHierarchyResolver) {
        this.resolver = classHierarchyResolver;
    }

    public ClassHierarchyResolver getClassHierarchyResolver() {
        return this.resolver;
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public static TransformRules load(Reader reader) throws IOException, RuleFormatException {
        TransformRuleParser transformRuleParser = new TransformRuleParser();
        List<TransformRule> list = transformRuleParser.parse(reader);
        return new TransformRules(list);
    }

    public static TransformRules load(File file) throws IOException, RuleFormatException {
        FileReader fileReader = new FileReader(file);
        return TransformRules.load(fileReader);
    }
}

