/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.parse.FullSystemWrapper;
import tratz.parse.io.ConllxSentenceReader;
import tratz.parse.transform.BasicStanfordTransformer;
import tratz.parse.types.Sentence;

public class SimpleParseServer {
    public static final String OPT_POS_MODEL = "posmodel";
    public static final String OPT_PARSE_MODEL = "parsemodel";
    public static final String OPT_POSSESSIVES_MODEL = "possmodel";
    public static final String OPT_NOUN_COMPOUND_MODEL = "nnmodel";
    public static final String OPT_PREPOSITIONS_MODEL = "psdmodel";
    public static final String OPT_SRL_ARGS_MODEL = "srlargsmodel";
    public static final String OPT_SRL_PREDICATES_MODEL = "srlpredmodel";
    public static final String OPT_WORDNET_DIR = "wndir";
    public static final String OPT_PORT_NUMBER = "port";
    public static final String DEFAULT_SENTENCE_READER_CLASS = ConllxSentenceReader.class.getName();
    private int mPortNumber;
    private ServerSocket mServerSocket;
    private volatile boolean mIsRunning;
    private FullSystemWrapper mFullSystem;

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOpts = new CommandLineOptions();
        cmdOpts.addOption(OPT_PORT_NUMBER, "integer", "port number to run server on");
        cmdOpts.addOption(OPT_POS_MODEL, "file", "part-of-speech tagging model file");
        cmdOpts.addOption(OPT_PARSE_MODEL, "file", "parser model file");
        cmdOpts.addOption(OPT_NOUN_COMPOUND_MODEL, "file", "noun compound interpretation model file");
        cmdOpts.addOption(OPT_PREPOSITIONS_MODEL, "file", "preposition disambiguation models file");
        cmdOpts.addOption(OPT_POSSESSIVES_MODEL, "file", "possessives interpretation model file");
        cmdOpts.addOption(OPT_SRL_PREDICATES_MODEL, "file", "semantic role labeling model file");
        cmdOpts.addOption(OPT_SRL_ARGS_MODEL, "file", "semantic role labeling model file");
        cmdOpts.addOption(OPT_WORDNET_DIR, "file", "WordNet dictionary (dict) directory");
        return cmdOpts;
    }

    public SimpleParseServer(int portNumber, FullSystemWrapper fullSystem) {
        this.mPortNumber = portNumber;
        this.mFullSystem = fullSystem;
    }

    public void launch() throws IOException {
        this.mServerSocket = new ServerSocket(this.mPortNumber);
        System.err.println("Server started, waiting to accept connections...");
        this.mIsRunning = true;
        while (this.mIsRunning) {
            Socket newConnection = this.mServerSocket.accept();
            System.err.println("Connection accepted");
            ClientConnectionHandlerRunnable runnable = null;
            try {
                runnable = new ClientConnectionHandlerRunnable(newConnection);
            }
            catch (IOException ioe) {
                System.err.println("Exception occurred while attempting to handle new connection");
                ioe.printStackTrace();
            }
            if (runnable == null) continue;
            new Thread(runnable).start();
        }
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(SimpleParseServer.createOptions(), args);
        String posModelFile = cmdLine.getStringValue(OPT_POS_MODEL);
        String wnDir = cmdLine.getStringValue(OPT_WORDNET_DIR);
        String parseModelFile = cmdLine.getStringValue(OPT_PARSE_MODEL);
        String possessivesModelFile = cmdLine.getStringValue(OPT_POSSESSIVES_MODEL);
        String nounCompoundModelFile = cmdLine.getStringValue(OPT_NOUN_COMPOUND_MODEL);
        String prepositionModelFile = cmdLine.getStringValue(OPT_PREPOSITIONS_MODEL);
        String srlArgsModelFile = cmdLine.getStringValue(OPT_SRL_ARGS_MODEL);
        String srlPredicatesModelFile = cmdLine.getStringValue(OPT_SRL_PREDICATES_MODEL);
        int portNumber = cmdLine.getIntegerValue(OPT_PORT_NUMBER);
        System.err.println("Port number: " + portNumber);
        FullSystemWrapper fullSysWrapper = new FullSystemWrapper(prepositionModelFile, nounCompoundModelFile, possessivesModelFile, srlArgsModelFile, srlPredicatesModelFile, posModelFile, parseModelFile, wnDir);
        SimpleParseServer server = new SimpleParseServer(portNumber, fullSysWrapper);
        server.launch();
    }

    public class ClientConnectionHandlerRunnable
    implements Runnable {
        private Socket mConnection;
        private ObjectInputStream mInputStream;
        private ObjectOutputStream mOutputStream;
        private boolean mIsRunning;

        public ClientConnectionHandlerRunnable(Socket connection) throws IOException {
            this.mConnection = connection;
            this.mOutputStream = new ObjectOutputStream(connection.getOutputStream());
            this.mInputStream = new ObjectInputStream(connection.getInputStream());
        }

        public void run() {
            this.mIsRunning = true;
            BasicStanfordTransformer basicStanTransform = new BasicStanfordTransformer();
            while (this.mIsRunning) {
                ParseRequest parseRequest = null;
                try {
                    parseRequest = (ParseRequest)this.mInputStream.readObject();
                }
                catch (EOFException eof) {
                    this.mIsRunning = false;
                    break;
                }
                catch (Exception e) {
                    System.err.println("Exception occurred while receiving data from client");
                    e.printStackTrace();
                    this.mIsRunning = false;
                    break;
                }
                Exception encounteredException = null;
                FullSystemWrapper.FullSystemResult fullResult = null;
                try {
                    fullResult = SimpleParseServer.this.mFullSystem.process(parseRequest.sentence, parseRequest.doPos, parseRequest.doParse, parseRequest.doPreps, parseRequest.doNNs, parseRequest.doPoss, parseRequest.doSRL);
                    if (parseRequest.doStanfordBasicTransform) {
                        basicStanTransform.performTransformation(fullResult.getParse());
                    }
                }
                catch (Exception e) {
                    encounteredException = e;
                }
                try {
                    ParseResult result = fullResult == null ? new ParseResult(encounteredException) : new ParseResult(fullResult);
                    this.mOutputStream.writeObject(result);
                    this.mOutputStream.flush();
                    this.mOutputStream.reset();
                }
                catch (Exception e) {
                    System.err.println("Exception occurred while sending data to client");
                    e.printStackTrace();
                    this.mIsRunning = false;
                }
            }
            try {
                this.mConnection.close();
            }
            catch (IOException e) {
                System.err.println("Exception while closing connection");
                e.printStackTrace();
            }
            System.err.println("Client handler thread exiting.");
        }
    }

    public static class ParseResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Exception mException;
        private FullSystemWrapper.FullSystemResult mFullResult;

        public ParseResult(Exception e) {
            this.mException = e;
        }

        public ParseResult(FullSystemWrapper.FullSystemResult parse) {
            this.mFullResult = parse;
        }

        public Exception getException() {
            return this.mException;
        }

        public FullSystemWrapper.FullSystemResult getResult() {
            return this.mFullResult;
        }
    }

    public static class ParseRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Sentence sentence;
        boolean doPos;
        boolean doParse;
        boolean doPreps;
        boolean doNNs;
        boolean doPoss;
        boolean doSRL;
        boolean doStanfordBasicTransform;

        public ParseRequest(Sentence sentence, boolean posTag, boolean parse, boolean prepDisambiguation, boolean nnDisambiguation, boolean possInterpretation, boolean srl, boolean stanfordBasicTransform) {
            this.sentence = sentence;
            this.doPos = posTag;
            this.doParse = parse;
            this.doPreps = prepDisambiguation;
            this.doNNs = nnDisambiguation;
            this.doPoss = possInterpretation;
            this.doSRL = srl;
            this.doStanfordBasicTransform = stanfordBasicTransform;
        }

        public ParseRequest(Sentence sentence) {
            this(sentence, true, true, true, true, true, true, false);
        }

        public Sentence getSentence() {
            return this.sentence;
        }
    }
}

