/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.io;

import java.io.FileWriter;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import tratz.jwni.WordNet;
import tratz.parse.io.SentenceWriter;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;
import tratz.parse.util.NLParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSentenceWriter
implements SentenceWriter {
    public static final String PARAM_OUTPUT_FILE = "output";
    public static final String SENTENCE_TAG = "s";
    public static final String WORDS_TAG = "words";
    public static final String WORD_TAG = "word";
    private XMLStreamWriter mXmlWriter;
    private int sentenceNum = 1;

    @Override
    public void initialize(Map<String, String> params) throws Exception {
        String outputFilename = params.get(PARAM_OUTPUT_FILE);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        this.mXmlWriter = xof.createXMLStreamWriter(new FileWriter(outputFilename));
        this.mXmlWriter.writeStartDocument("1.0");
        this.mXmlWriter.writeStartElement("sentences");
    }

    @Override
    public void appendSentence(Sentence sentence, Parse parse) {
        this.appendSentence(sentence, parse, null);
    }

    @Override
    public void appendSentence(Sentence sentence, Parse parse, Arc[] tokenToSemanticHead) {
        List<Token> tokens = sentence.getTokens();
        try {
            this.mXmlWriter.writeStartElement(SENTENCE_TAG);
            this.mXmlWriter.writeAttribute("id", "" + this.sentenceNum);
            this.mXmlWriter.writeStartElement(WORDS_TAG);
            for (Token t : tokens) {
                this.mXmlWriter.writeStartElement(WORD_TAG);
                this.mXmlWriter.writeAttribute("ind", "" + t.getIndex());
                this.mXmlWriter.writeAttribute("pos", "" + t.getPos());
                this.mXmlWriter.writeAttribute("lemma", "" + NLParserUtils.getLemma(t, WordNet.getInstance()));
                this.mXmlWriter.writeCharacters(t.getText());
                this.mXmlWriter.writeEndElement();
            }
            this.mXmlWriter.writeStartElement("dependencies");
            this.mXmlWriter.writeAttribute("style", "typed");
            for (Token t : tokens) {
                Arc headarc = parse.getHeadArcs()[t.getIndex()];
                if (headarc == null) {
                    headarc = new Arc(t, parse.getRoot(), "ROOT");
                }
                this.mXmlWriter.writeStartElement("dep");
                this.mXmlWriter.writeAttribute("type", headarc.getDependency());
                this.mXmlWriter.writeStartElement("governor");
                this.mXmlWriter.writeAttribute("idx", "" + headarc.getHead().getIndex());
                this.mXmlWriter.writeCharacters(headarc.getHead().getText());
                this.mXmlWriter.writeEndElement();
                this.mXmlWriter.writeStartElement("dependent");
                this.mXmlWriter.writeAttribute("idx", "" + headarc.getChild().getIndex());
                this.mXmlWriter.writeCharacters(headarc.getChild().getText());
                this.mXmlWriter.writeEndElement();
                this.mXmlWriter.writeEndElement();
            }
            this.mXmlWriter.writeEndElement();
            this.mXmlWriter.writeEndElement();
            this.mXmlWriter.writeEndElement();
            ++this.sentenceNum;
        }
        catch (XMLStreamException xse) {
            throw new RuntimeException(xse);
        }
    }

    @Override
    public void close() {
        try {
            this.mXmlWriter.writeEndElement();
            this.mXmlWriter.writeEndDocument();
            this.mXmlWriter.close();
        }
        catch (XMLStreamException xse) {
            throw new RuntimeException(xse);
        }
    }

    @Override
    public void flush() {
        try {
            this.mXmlWriter.flush();
        }
        catch (XMLStreamException xse) {
            throw new RuntimeException(xse);
        }
    }
}

