/*
 * Decompiled with CFR 0.152.
 */
package tratz.runpipe.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import tratz.runpipe.Annotation;
import tratz.runpipe.TextDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunpipeUtils {
    public static <T extends Annotation> List<T> getSublist(Annotation boundaryAnnot, List<T> list) {
        int start = boundaryAnnot.getStart();
        int end = boundaryAnnot.getEnd();
        int result = Collections.binarySearch(list, boundaryAnnot);
        result = -(result + 1);
        result = Math.max(0, result - 1);
        ArrayList<Annotation> subList = new ArrayList<Annotation>();
        int numAnnots = list.size();
        for (int i = 0; i < numAnnots; ++i) {
            Annotation annot = (Annotation)list.get(i);
            int annotStart = annot.getStart();
            if (annotStart < start) continue;
            if (annotStart >= end) break;
            if (annot.getEnd() > end) continue;
            subList.add(annot);
        }
        return subList;
    }

    public static List<Annotation> getAllAnnotsInList(TextDocument doc, Class[] listOfTypes) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Class clazz : listOfTypes) {
            TreeSet<? extends Annotation> annots = doc.getAnnotationSet(clazz);
            if (annots == null) continue;
            annotations.addAll(annots);
        }
        Collections.sort(annotations);
        return annotations;
    }
}

