/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import tratz.parse.io.SentenceWriter;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSentenceWriter
implements SentenceWriter {
    public static final String PARAM_OUTPUT_FILE = "output";
    public static final String PARAM_AUTO_FLUSH = "autoflush";
    private PrintWriter mWriter;
    private boolean mAutoFlush = true;

    @Override
    public void initialize(Map<String, String> args) throws IOException {
        String outputFile = args.get(PARAM_OUTPUT_FILE);
        this.mWriter = outputFile != null ? new PrintWriter(new FileWriter(outputFile)) : new PrintWriter(new OutputStreamWriter(System.out));
        String autoflush = args.get(PARAM_AUTO_FLUSH);
        if (autoflush != null) {
            this.mAutoFlush = Boolean.parseBoolean(autoflush);
        }
    }

    @Override
    public void appendSentence(Sentence sentence, Parse parse, Arc[] tokenToSemanticHead) {
        List<Token> tokens = sentence.getTokens();
        int numTokens = tokens.size();
        for (int i = 0; i < numTokens; ++i) {
            Arc semArc;
            Token token = tokens.get(i);
            Arc arc = parse.getHeadArcs()[token.getIndex()];
            if (arc == null) {
                arc = new Arc(token, new Token("", 0), "ROOT");
            }
            this.mWriter.print(i + 1);
            this.mWriter.print("\t");
            this.mWriter.print(token.getText());
            this.mWriter.print("\t_\t");
            this.mWriter.print(token.getCoarsePos() == null ? "_" : token.getCoarsePos());
            this.mWriter.print("\t");
            this.mWriter.print(token.getPos() == null ? "_" : token.getPos());
            this.mWriter.print("\t_\t");
            this.mWriter.print(arc.getHead() == null ? 0 : arc.getHead().getIndex());
            this.mWriter.print("\t");
            this.mWriter.print(arc.getDependency() + "\t");
            this.mWriter.print("_\t_");
            this.mWriter.print("\t");
            this.mWriter.print(token.getLexSense() != null ? token.getLexSense() : "_");
            this.mWriter.print("\t");
            this.mWriter.print(arc.getSemanticAnnotation() != null ? arc.getSemanticAnnotation() : "_");
            this.mWriter.print("\t");
            Arc arc2 = semArc = tokenToSemanticHead == null ? null : tokenToSemanticHead[token.getIndex()];
            if (semArc != null && semArc.getSemanticAnnotation() != null) {
                this.mWriter.print(semArc.getSemanticAnnotation());
                this.mWriter.print("\t");
                this.mWriter.print(semArc.getHead() == null ? -1 : semArc.getHead().getIndex());
            } else {
                this.mWriter.print("_\t_");
            }
            this.mWriter.println();
        }
        this.mWriter.println();
        if (this.mAutoFlush) {
            this.flush();
        }
    }

    @Override
    public void appendSentence(Sentence sentence, Parse parse) {
        this.appendSentence(sentence, parse, null);
    }

    @Override
    public void flush() {
        this.mWriter.flush();
    }

    @Override
    public void close() {
        this.mWriter.close();
    }
}

