/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.srl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.featgen.MultiStepFeatureGenerator;
import tratz.jwni.WordNet;
import tratz.parse.io.ConllxSentenceReader;
import tratz.parse.transform.VchTransformer;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;
import tratz.semantics.srl.SemanticArc;
import tratz.semantics.srl.SentenceReaderForSRL;

public class FeatureExtractionRoutine {
    public static final String OPT_INPUT_FILES = "input";
    public static final String OPT_OUTPUT_DIR = "outputdir";
    public static final String OPT_AUTOPARSED_FILES = "autoparsedfiles";
    public static final String OPT_WORDNET_DIR = "wndir";
    public static final String OPT_WFR_RULES = "wfr";
    public static final String OPT_FEATURE_RULES = "fer";
    public static final String OPT_COMBO_RULES = "comborules";
    public static final String OPT_IS_FOR_TESTING = "isfortesting";
    public static final String OPT_TRUTH_FILE = "truthfile";
    public static Set<String> SKIP_DEPS = new HashSet<String>(Arrays.asList("det", "cleft", "nn", "num", "num", "conj", "mark", "measure", "pobj", "pcomp", "expl", "vch", "dep", "cc", "combo", "complm", "appos", "parataxis", "preconj", "predet", "poss", "postloc", "possessive", "punct", "rcmod", "sccomp", "quantmod", "ROOT"));

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOpts = new CommandLineOptions();
        cmdOpts.addOption(OPT_INPUT_FILES, "file(s)", "file(s) containing the srl info");
        cmdOpts.addOption(OPT_OUTPUT_DIR, "file", "directory for output files");
        cmdOpts.addOption(OPT_AUTOPARSED_FILES, "file(s)", "file(s) containing versions of the files parsed using an automatic parser");
        cmdOpts.addOption(OPT_WORDNET_DIR, "file", "the dictionary (dict) directory of WordNet");
        cmdOpts.addOption(OPT_WFR_RULES, "file", "the file containing the word-finding rules");
        cmdOpts.addOption(OPT_FEATURE_RULES, "file", "the file containing the feature extraction rules");
        cmdOpts.addOption(OPT_COMBO_RULES, "file", "the file containing the combination rules");
        cmdOpts.addOption(OPT_IS_FOR_TESTING, "boolean", "indicates if the features being generated are for testing");
        cmdOpts.addOption(OPT_TRUTH_FILE, "file", "file that will contain two columns (1) the list of ids (2) the correct assignments");
        return cmdOpts;
    }

    public static void main(String[] args) throws Exception {
        boolean generateFeaturesUsingAutoParse;
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(FeatureExtractionRoutine.createOptions(), args);
        String inputFiles = cmdLine.getStringValue(OPT_INPUT_FILES);
        File outputDir = new File(cmdLine.getStringValue(OPT_OUTPUT_DIR));
        String autoparsedFiles = cmdLine.getStringValue(OPT_AUTOPARSED_FILES);
        String wordNetDir = cmdLine.getStringValue(OPT_WORDNET_DIR);
        String wfrListFile = cmdLine.getStringValue(OPT_WFR_RULES);
        String featRulesFile = cmdLine.getStringValue(OPT_FEATURE_RULES);
        String comboFile = cmdLine.getStringValue(OPT_COMBO_RULES);
        boolean bl = generateFeaturesUsingAutoParse = autoparsedFiles != null;
        if (generateFeaturesUsingAutoParse) {
            System.err.println("Generating features using automatic parse output");
        }
        boolean isForTesting = cmdLine.getBooleanValue(OPT_IS_FOR_TESTING);
        File truthFile = new File(cmdLine.getStringValue(OPT_TRUTH_FILE));
        new WordNet(new File(wordNetDir));
        VchTransformer vchTransformer = new VchTransformer();
        MultiStepFeatureGenerator featGen = new MultiStepFeatureGenerator(wfrListFile, featRulesFile, comboFile);
        ConllxSentenceReader conllxReader = new ConllxSentenceReader();
        PrintWriter truthWriter = new PrintWriter(new FileWriter(truthFile));
        HashMap<String, PrintWriter> dependencyTypeToWriter = new HashMap<String, PrintWriter>();
        String[] inFiles = inputFiles.split(File.pathSeparator);
        String[] autoparsed = null;
        if (autoparsedFiles != null) {
            autoparsed = autoparsedFiles.split(File.pathSeparator);
        }
        for (int f = 0; f < inFiles.length; ++f) {
            String inFile = inFiles[f];
            String autoFile = null;
            if (autoparsed != null) {
                autoFile = autoparsed[f];
            }
            BufferedReader goldReader = new BufferedReader(new FileReader(inFile));
            BufferedReader autoParseReader = null;
            if (autoFile != null) {
                autoParseReader = new BufferedReader(new FileReader(autoFile));
            }
            Object[] readResult = null;
            SentenceReaderForSRL srlReader = new SentenceReaderForSRL();
            int lineno = 0;
            int snum = 0;
            while ((readResult = srlReader.readSentence(goldReader)) != null && readResult[0] != null) {
                ++snum;
                ++lineno;
                Parse goldParse = (Parse)readResult[0];
                Parse autoParse = null;
                if (autoParseReader != null) {
                    autoParse = conllxReader.readSentence(autoParseReader);
                }
                if (autoParse != null) {
                    vchTransformer.performTransformation(autoParse);
                }
                Arc[] tokenToHead = goldParse.getHeadArcs();
                Map semArcs = (Map)readResult[1];
                List<Token> tokens = goldParse.getSentence().getTokens();
                List<Token> tokensAUTO = autoParse != null ? autoParse.getSentence().getTokens() : null;
                int numTokens = tokens.size();
                for (int tokNum = 1; tokNum < numTokens + 1; ++tokNum) {
                    PrintWriter writer;
                    boolean arcMismatch;
                    String depAUTO;
                    String clazz;
                    Arc arcAUTO;
                    ++lineno;
                    Arc a = tokenToHead[tokNum];
                    Arc arc = arcAUTO = autoParse != null ? autoParse.getHeadArcs()[tokNum] : null;
                    if (a == null && arcAUTO == null) continue;
                    SemanticArc semArc = (SemanticArc)semArcs.get(a);
                    String fullForm = null;
                    if (semArc != null) {
                        fullForm = semArc.getFullForm();
                        clazz = semArc.getType();
                    } else {
                        fullForm = "NA";
                        clazz = "NA";
                    }
                    String label = lineno + "_" + snum + "_" + (a == null ? "" : a.getHead().getIndex() + "_" + a.getChild().getIndex());
                    String dep = a == null ? null : a.getDependency();
                    String string = depAUTO = arcAUTO == null ? null : arcAUTO.getDependency();
                    if (dep != null && dep.equals("pobj") && a.getHead().getPos().startsWith("V")) {
                        dep = "dobj";
                    }
                    if (depAUTO != null && depAUTO.equals("pobj") && arcAUTO.getHead().getPos().startsWith("V")) {
                        depAUTO = "dobj";
                    }
                    if (a != null && (a != null && !SKIP_DEPS.contains(dep) || arcAUTO != null && !SKIP_DEPS.contains(depAUTO))) {
                        truthWriter.println(label + "\t" + clazz);
                    }
                    if ((generateFeaturesUsingAutoParse || a == null || SKIP_DEPS.contains(dep)) && (!generateFeaturesUsingAutoParse || arcAUTO == null || SKIP_DEPS.contains(depAUTO))) continue;
                    boolean bl2 = a == null || arcAUTO == null || a.getChild().getIndex() != arcAUTO.getChild().getIndex() || (a.getHead() == null ? 0 : a.getHead().getIndex()) != (arcAUTO.getHead() == null ? 0 : arcAUTO.getHead().getIndex()) ? true : (arcMismatch = false);
                    if (generateFeaturesUsingAutoParse && (!arcMismatch || !isForTesting) && arcMismatch) continue;
                    String depWriterName = generateFeaturesUsingAutoParse && !SKIP_DEPS.contains(depAUTO) ? depAUTO : dep;
                    if (depWriterName.equals("prep")) {
                        depWriterName = "prep_" + tokens.get(tokNum - 1).getText().toLowerCase();
                    }
                    if (depWriterName.equals("partmod")) {
                        depWriterName = "partmod_" + (generateFeaturesUsingAutoParse ? tokensAUTO.get(tokNum - 1).getPos() : tokens.get(tokNum - 1).getPos());
                    }
                    if (generateFeaturesUsingAutoParse) {
                        label = lineno + "_" + snum + "_" + arcAUTO.getHead().getIndex() + "_" + arcAUTO.getChild().getIndex();
                    }
                    if (generateFeaturesUsingAutoParse && arcMismatch) {
                        clazz = "DUMBY";
                        if (!isForTesting) {
                            System.err.println("Can't use auto parsed data with vs-gold-mismatches for training");
                        }
                    }
                    if ((writer = (PrintWriter)dependencyTypeToWriter.get(depWriterName)) == null) {
                        outputDir.mkdirs();
                        writer = new PrintWriter(new FileWriter(new File(outputDir, depWriterName)));
                        dependencyTypeToWriter.put(depWriterName, writer);
                    }
                    writer.print(label + "\u0018" + clazz + "\u0018");
                    Set<String> feats = null;
                    feats = featGen.generateFeatures(generateFeaturesUsingAutoParse ? autoParse.getSentence().getTokens() : goldParse.getSentence().getTokens(), generateFeaturesUsingAutoParse ? autoParse : goldParse, tokNum - 1);
                    ArrayList<String> featList = new ArrayList<String>(feats);
                    Collections.sort(featList);
                    int numFeats = featList.size();
                    for (int i = 0; i < numFeats; ++i) {
                        String feat = (String)featList.get(i);
                        writer.print(feat);
                        writer.print('\u0018');
                    }
                    writer.println();
                }
            }
            System.err.println("Number of sentences processed: " + snum);
            goldReader.close();
            if (autoParseReader != null) {
                autoParseReader.close();
            }
            truthWriter.close();
        }
        for (PrintWriter writer : dependencyTypeToWriter.values()) {
            writer.close();
        }
    }
}

