/*
 * Decompiled with CFR 0.152.
 */
package tratz.jwikt;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tratz.jwikt.LinkType;
import tratz.jwikt.WEntry;
import tratz.jwikt.WPOS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wiktionary {
    protected static Wiktionary mGlobal;
    private List<String> mAllTerms;
    private Map<WPOS, Map<String, WEntry>> mPosToTermToEntry;
    private Map<WEntry, Map<LinkType, List<String>>> mEntryToLinkTypeToString;

    public static Wiktionary getGlobal() {
        return mGlobal;
    }

    public static void setGlobal(Wiktionary wiktionary) {
        mGlobal = wiktionary;
    }

    public Wiktionary(Map<WPOS, Map<String, WEntry>> posToTermToEntry, Map<WEntry, Map<LinkType, List<String>>> entryToLinkTypeToString, List<String> allTerms) {
        this.mAllTerms = allTerms;
        this.mPosToTermToEntry = posToTermToEntry;
        this.mEntryToLinkTypeToString = entryToLinkTypeToString;
    }

    public Map<WPOS, Map<String, WEntry>> getMap() {
        return this.mPosToTermToEntry;
    }

    public Map<WEntry, Map<LinkType, List<String>>> getLinkMap() {
        return this.mEntryToLinkTypeToString;
    }

    public List<String> getTerms() {
        return this.mAllTerms;
    }

    public WEntry getEntry(WPOS pos, String term) {
        Map<String, WEntry> termToEntry = this.mPosToTermToEntry.get((Object)pos);
        return termToEntry == null ? null : termToEntry.get(term);
    }

    public static Wiktionary readWiktionary(String inFile) throws IOException {
        Object[][] maps;
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        String line = null;
        HashSet<String> cats = new HashSet<String>();
        HashMap<String, Integer> sToCount = new HashMap<String, Integer>();
        Object[][] stringToLinkType = new Object[][]{{"Antonyms", LinkType.ANTONYM}, {"Synonyms", LinkType.SYNONYM}, {"Related terms", LinkType.RELATED_TERM}, {"Derived terms", LinkType.DERIVED_TERM}, {"See also", LinkType.SEE_ALSO}, {"Hyponyms", LinkType.HYPONYM}, {"Troponyms", LinkType.HYPONYM}, {"Scientific names", LinkType.SCIENTIFIC_NAME}, {"Hypernyms", LinkType.HYPERNYM}, {"Holonyms", LinkType.HOLONYM}, {"Meronymns", LinkType.MERONYM}, {"Coordinate terms", LinkType.COORDINATE_TERM}};
        HashMap<String, LinkType> stringToLinkTypeMap = new HashMap<String, LinkType>();
        for (Object[] mapping : stringToLinkType) {
            String s = (String)mapping[0];
            LinkType type = (LinkType)((Object)mapping[1]);
            stringToLinkTypeMap.put(s, type);
        }
        HashMap<WEntry, Map<LinkType, List<String>>> entryToLinkTypeToStrings = new HashMap<WEntry, Map<LinkType, List<String>>>();
        HashMap<String, WPOS> pstringToPos = new HashMap<String, WPOS>();
        for (Object[] mapping : maps = new Object[][]{{"Adjective", WPOS.ADJECTIVE}, {"Adverb", WPOS.ADVERB}, {"Determiner", WPOS.DETERMINER}, {"Noun", WPOS.NOUN}, {"Verb", WPOS.VERB}, {"Article", WPOS.ART}, {"Conjunction", WPOS.CONJ}, {"Pronoun", WPOS.PRONOUN}, {"Abbreviation", WPOS.ABBREV}, {"Proper noun", WPOS.PROPER_NOUN}, {"{{acronym}}", WPOS.ACRONYM}, {"{{acronym|en}}", WPOS.ACRONYM}, {"{{acronym|English}}", WPOS.ACRONYM}, {"{{acronym|mul}}", WPOS.ACRONYM}, {"Acronym", WPOS.ACRONYM}, {"{{abbreviation|en}}", WPOS.ABBREV}, {"{{abbreviation|English}}", WPOS.ABBREV}, {"{{abbreviation}}", WPOS.ABBREV}, {"Initialism", WPOS.INITIALISM}, {"Preposition", WPOS.PREP}, {"{{initialism|English}}", WPOS.INITIALISM}, {"{{initialism|english}}", WPOS.INITIALISM}, {"{{initialism|en}}", WPOS.INITIALISM}, {"{{initialism|eu}}", WPOS.INITIALISM}, {"{{initialism}}", WPOS.INITIALISM}}) {
            pstringToPos.put((String)mapping[0], (WPOS)((Object)mapping[1]));
        }
        HashSet<String> allTerms = new HashSet<String>();
        boolean printFromPage = false;
        boolean inInterestingSubsection = false;
        Matcher languageMatcher = Pattern.compile("==([^\\]=]*)==\\s*").matcher("");
        Matcher typeMatcher = Pattern.compile("====*([^\\]=]*)=*===\\s*").matcher("");
        Matcher titleMatcher = Pattern.compile("TITLE:(.*)").matcher("");
        Matcher appendixTitleMatcher = Pattern.compile("\\s*<title>((Wikisaurus|Image|WS|WT|Concordance|Special|User|File|MediaWiki|Rhymes|Transwiki|Citations|MediaWiki|Index|Template|Category|Help|Appendix|Wiktionary)([\\s_]talk)?):(.*)</title>\\s*").matcher("");
        String title = null;
        String sectionType = null;
        HashMap<WPOS, Map<String, WEntry>> posToTermToEntry = new HashMap<WPOS, Map<String, WEntry>>();
        WPOS pos = null;
        LinkType linkType = null;
        WEntry currentEntry = null;
        WEntry.Definition def = null;
        ArrayList<String> linkStrings = null;
        HashMap linkTypeToStrings = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("[[Category:")) {
                cats.add(line);
                continue;
            }
            if (titleMatcher.reset(line).matches()) {
                printFromPage = !appendixTitleMatcher.reset(line).matches();
                title = titleMatcher.group(1);
                continue;
            }
            if (printFromPage && languageMatcher.reset(line).matches()) continue;
            if (line.contains("</text>")) {
                inInterestingSubsection = false;
                continue;
            }
            if (typeMatcher.reset(line).matches()) {
                String subsection = typeMatcher.group(1).trim();
                allTerms.add(subsection);
                sectionType = subsection;
                pos = (WPOS)((Object)pstringToPos.get(sectionType));
                if (pos != null) {
                    linkTypeToStrings = new HashMap();
                    currentEntry = new WEntry(title, pos);
                    entryToLinkTypeToStrings.put(currentEntry, linkTypeToStrings);
                    HashMap<String, WEntry> termToEntry = (HashMap<String, WEntry>)posToTermToEntry.get((Object)pos);
                    if (termToEntry == null) {
                        termToEntry = new HashMap<String, WEntry>();
                        posToTermToEntry.put(pos, termToEntry);
                    }
                    termToEntry.put(title, currentEntry);
                    continue;
                }
                linkType = null;
                linkType = (LinkType)((Object)stringToLinkTypeMap.get(sectionType));
                if (linkType != null) {
                    linkStrings = new ArrayList<String>();
                    linkTypeToStrings.put(linkType, linkStrings);
                    continue;
                }
                System.err.println(line);
                continue;
            }
            if (pos != null) {
                if (line.startsWith("#:")) {
                    def.getExamples().add(line.substring(2).trim().replaceAll("\\[\\[(w:)?([^\\]\\|]*)[^\\]]*\\]\\]", "$2"));
                    continue;
                }
                if (line.startsWith("#*:") || line.startsWith("#:") && line.contains("\u2014") || line.startsWith("#*")) continue;
                if (line.startsWith("#")) {
                    String gpart = line.substring(1).trim();
                    if (!(!gpart.startsWith("{{") || gpart.startsWith("{{superlative of") || gpart.startsWith("{{alternative form of") || gpart.startsWith("{{comparative of") || gpart.startsWith("{{plural of") || gpart.startsWith("{{present participle") || gpart.startsWith("{{third-person") || gpart.startsWith("{{alternative spelling") || gpart.startsWith("{{past of") || gpart.indexOf("}}") <= 0)) {
                        for (String s : gpart.substring(2, gpart.indexOf("}")).split("\\|")) {
                            Integer count = (Integer)sToCount.get(s);
                            if (count == null) {
                                count = new Integer(0);
                            }
                            sToCount.put(s, count + 1);
                        }
                        gpart = gpart.substring(gpart.indexOf("}}") + 2);
                    }
                    String gloss = line.substring(1).trim().replaceAll("\\[\\[(w:|wikipedia:|Wikipedia:)?([^\\]\\|]*)([^\\]])*\\]\\]", "$2");
                    if (!(gloss = gloss.trim()).startsWith("{{superlative of") && !gloss.startsWith("{{comparative of")) {
                        gloss = gloss.replaceAll("\\{\\{[^\\}]*\\}\\}", "");
                    }
                    if ((gloss = gloss.trim()).equals("")) continue;
                    def = new WEntry.Definition(gloss);
                    currentEntry.addDefinition(def);
                    continue;
                }
                if (line.trim().equals("")) continue;
                currentEntry.mJunk.add(line);
                continue;
            }
            if (linkType == null) continue;
            if (line.startsWith("*")) {
                if ((line = line.substring(1).trim()).startsWith("*") && line.length() > 1) {
                    line = line.substring(1).trim();
                }
                line = line.replaceAll("\\s*See also\\s*\\[\\[Wikisaurus:([^\\]]*)\\]\\]", "$1");
                linkStrings.add(line);
                continue;
            }
            if (line.trim().equals("")) continue;
        }
        reader.close();
        ArrayList<String> list = new ArrayList<String>(allTerms);
        Collections.sort(list);
        return new Wiktionary(posToTermToEntry, entryToLinkTypeToStrings, list);
    }

    public static void main(String[] args) throws Exception {
        PrintWriter writer = new PrintWriter(new FileWriter("/media/1500GB_/regurge.txt"));
        Wiktionary wiktionary = Wiktionary.readWiktionary("/media/1500GB_/limited");
        List<String> list = wiktionary.getTerms();
        Map<WPOS, Map<String, WEntry>> posToTermToEntry = wiktionary.getMap();
        Map<WEntry, Map<LinkType, List<String>>> entryToLinkTypeToStrings = wiktionary.getLinkMap();
        System.err.println("Print:");
        for (String s : list) {
            System.err.println(s);
        }
        System.err.println(list.size());
        for (WPOS wpos : posToTermToEntry.keySet()) {
            Map<String, WEntry> termToEntry = posToTermToEntry.get((Object)wpos);
            ArrayList<String> allEntries = new ArrayList<String>(termToEntry.keySet());
            Collections.sort(allEntries);
            for (String entryName : allEntries) {
                WEntry entry = termToEntry.get(entryName);
                if (entry.getDefinitions().size() == 0) continue;
                writer.println(entry.getTerm() + "\t" + (Object)((Object)entry.getPos()));
                for (WEntry.Definition def2 : entry.getDefinitions()) {
                    writer.println("\t" + def2.getGloss());
                    for (String ex : def2.getExamples()) {
                        writer.println("\t\t" + ex);
                    }
                }
                Map<LinkType, List<String>> linkTypeToStrings2 = entryToLinkTypeToStrings.get(entry);
                for (LinkType lt : linkTypeToStrings2.keySet()) {
                    List<String> targets = linkTypeToStrings2.get((Object)lt);
                    writer.println("\t" + (Object)((Object)lt));
                    for (String s : targets) {
                        writer.println("\t\t" + s);
                    }
                }
            }
        }
        writer.close();
    }
}

