/*
 * Decompiled with CFR 0.152.
 */
package opennlp.perceptron;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.Context;
import opennlp.model.EvalParameters;
import opennlp.perceptron.PerceptronModelReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerceptronModel
extends AbstractModel {
    public PerceptronModel(Context[] contextArray, String[] stringArray, Map<String, Integer> map, String[] stringArray2) {
        super(contextArray, stringArray, stringArray2);
        this.modelType = AbstractModel.ModelType.Perceptron;
    }

    public PerceptronModel(Context[] contextArray, String[] stringArray, String[] stringArray2) {
        super(contextArray, stringArray, stringArray2);
        this.modelType = AbstractModel.ModelType.Perceptron;
    }

    @Override
    public double[] eval(String[] stringArray) {
        return this.eval(stringArray, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] stringArray, float[] fArray) {
        return this.eval(stringArray, fArray, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] stringArray, double[] dArray) {
        return this.eval(stringArray, null, dArray);
    }

    public double[] eval(String[] stringArray, float[] fArray, double[] dArray) {
        int[] nArray = new int[stringArray.length];
        Arrays.fill(dArray, 0.0);
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = this.pmap.get(stringArray[i]);
            nArray[i] = n == null ? -1 : n;
        }
        return PerceptronModel.eval(nArray, fArray, dArray, this.evalParams, true);
    }

    public static double[] eval(int[] nArray, double[] dArray, EvalParameters evalParameters) {
        return PerceptronModel.eval(nArray, null, dArray, evalParameters, true);
    }

    public static double[] eval(int[] nArray, float[] fArray, double[] dArray, EvalParameters evalParameters, boolean bl) {
        block10: {
            int n;
            Context[] contextArray = evalParameters.getParams();
            double d = 1.0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0) continue;
                Context context = contextArray[nArray[i]];
                int[] nArray2 = context.getOutcomes();
                double[] dArray2 = context.getParameters();
                if (fArray != null) {
                    d = fArray[i];
                }
                for (int j = 0; j < nArray2.length; ++j) {
                    int n2;
                    int n3 = n2 = nArray2[j];
                    dArray[n3] = dArray[n3] + dArray2[j] * d;
                }
            }
            if (!bl) break block10;
            double d2 = 0.0;
            double d3 = dArray[0];
            for (n = 0; n < evalParameters.getNumOutcomes(); ++n) {
                if (!(dArray[n] < d3)) continue;
                d3 = dArray[n];
            }
            for (n = 0; n < evalParameters.getNumOutcomes(); ++n) {
                if (d3 < 0.0) {
                    int n4 = n;
                    dArray[n4] = dArray[n4] + -1.0 * d3;
                }
                d2 += dArray[n];
            }
            if (d2 == 0.0) {
                for (n = 0; n < evalParameters.getNumOutcomes(); ++n) {
                    dArray[n] = 1.0 / (double)evalParameters.getNumOutcomes();
                }
            } else {
                n = 0;
                while (n < evalParameters.getNumOutcomes()) {
                    int n5 = n++;
                    dArray[n5] = dArray[n5] / d2;
                }
            }
        }
        return dArray;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: PerceptronModel modelname < contexts");
            System.exit(1);
        }
        AbstractModel abstractModel = new PerceptronModelReader(new File(stringArray[0])).getModel();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        DecimalFormat decimalFormat = new DecimalFormat(".###");
        String string = bufferedReader.readLine();
        while (string != null) {
            String[] stringArray2 = string.split(" ");
            double[] dArray = abstractModel.eval(stringArray2);
            for (int i = 0; i < dArray.length; ++i) {
                System.out.print("[" + abstractModel.getOutcome(i) + " " + decimalFormat.format(dArray[i]) + "] ");
            }
            System.out.println();
            string = bufferedReader.readLine();
        }
    }
}

