/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.relationship;

import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTree;
import net.didion.jwnl.data.relationship.Relationship;
import net.didion.jwnl.data.relationship.RelationshipList;

public class AsymmetricRelationship
extends Relationship {
    private static final int DEFAULT_SEARCH_DEPTH = Integer.MAX_VALUE;
    private int _commonParentIndex;
    private transient int _cachedRelativeTargetDepth = -1;

    private AsymmetricRelationship(PointerTargetNodeList pointerTargetNodeList, int n, Relationship relationship) {
        super(pointerTargetNodeList, relationship);
        this._commonParentIndex = n;
    }

    private AsymmetricRelationship(PointerType pointerType, Synset synset, Synset synset2) {
        super(pointerType, synset, synset2);
    }

    private AsymmetricRelationship(PointerType pointerType, PointerTargetNodeList pointerTargetNodeList, int n, Synset synset, Synset synset2) {
        super(pointerType, pointerTargetNodeList, synset, synset2);
        this._commonParentIndex = n;
    }

    public int getCommonParentIndex() {
        return this._commonParentIndex;
    }

    public int getRelativeTargetDepth() {
        if (this._cachedRelativeTargetDepth == -1) {
            int n = this._commonParentIndex;
            int n2 = this.getNodeList().size() - 1 - this._commonParentIndex;
            this._cachedRelativeTargetDepth = n2 - n;
        }
        return this._cachedRelativeTargetDepth;
    }

    public Relationship reverse() {
        PointerTargetNodeList pointerTargetNodeList = ((PointerTargetNodeList)this.getNodeList().deepClone()).reverse();
        int n = pointerTargetNodeList.size() - 1 - this.getCommonParentIndex();
        int n2 = 0;
        while (n2 < pointerTargetNodeList.size()) {
            if (n2 != n) {
                ((PointerTargetNode)pointerTargetNodeList.get(n2)).setType(this.getType().getSymmetricType());
            }
            ++n2;
        }
        return new AsymmetricRelationship(pointerTargetNodeList, n, this);
    }

    static RelationshipList findAsymmetricRelationships(Synset synset, Synset synset2, PointerType pointerType) throws JWNLException {
        return AsymmetricRelationship.findAsymmetricRelationships(synset, synset2, pointerType, Integer.MAX_VALUE);
    }

    static RelationshipList findAsymmetricRelationships(Synset synset, Synset synset2, PointerType pointerType, int n) throws JWNLException {
        PointerTargetNodeList[] pointerTargetNodeListArray = new PointerTargetTree(synset, PointerUtils.makePointerTargetTreeList(synset, pointerType, n)).reverse();
        PointerTargetNodeList[] pointerTargetNodeListArray2 = new PointerTargetTree(synset2, PointerUtils.makePointerTargetTreeList(synset2, pointerType, n)).reverse();
        PointerTargetNode[][] pointerTargetNodeArrayArray = new PointerTargetNode[pointerTargetNodeListArray.length][];
        PointerTargetNode[][] pointerTargetNodeArrayArray2 = new PointerTargetNode[pointerTargetNodeListArray2.length][];
        int n2 = 0;
        while (n2 < pointerTargetNodeListArray.length) {
            pointerTargetNodeArrayArray[n2] = (PointerTargetNode[])pointerTargetNodeListArray[n2].toArray(new PointerTargetNode[pointerTargetNodeListArray[n2].size()]);
            ++n2;
        }
        n2 = 0;
        while (n2 < pointerTargetNodeListArray2.length) {
            pointerTargetNodeArrayArray2[n2] = (PointerTargetNode[])pointerTargetNodeListArray2[n2].toArray(new PointerTargetNode[pointerTargetNodeListArray2[n2].size()]);
            ++n2;
        }
        RelationshipList relationshipList = new RelationshipList();
        AsymmetricRelationship asymmetricRelationship = new AsymmetricRelationship(pointerType, synset, synset2);
        n2 = 0;
        while (n2 < pointerTargetNodeListArray.length) {
            int n3 = 0;
            while (n3 < pointerTargetNodeListArray2.length) {
                Relationship relationship = AsymmetricRelationship.findAsymmetricRelationship(pointerTargetNodeArrayArray[n2], pointerTargetNodeArrayArray2[n3], asymmetricRelationship);
                if (relationship != null) {
                    relationshipList.add(relationship);
                }
                ++n3;
            }
            ++n2;
        }
        return relationshipList;
    }

    private static Relationship findAsymmetricRelationship(PointerTargetNode[] pointerTargetNodeArray, PointerTargetNode[] pointerTargetNodeArray2, Relationship relationship) {
        PointerTargetNodeList pointerTargetNodeList = null;
        if (pointerTargetNodeArray[0].getSynset().equals(pointerTargetNodeArray2[0].getSynset())) {
            int n;
            pointerTargetNodeList = new PointerTargetNodeList();
            int n2 = 1;
            while (n2 < pointerTargetNodeArray.length && n2 < pointerTargetNodeArray2.length && pointerTargetNodeArray[n2].getSynset().equals(pointerTargetNodeArray2[n2].getSynset())) {
                ++n2;
            }
            int n3 = n2 - 1;
            int n4 = 0;
            if (n2 < pointerTargetNodeArray.length) {
                n4 = pointerTargetNodeArray.length - 1 - n3;
                n = pointerTargetNodeArray.length - 1;
                while (n > n3) {
                    pointerTargetNodeList.add(pointerTargetNodeArray[n]);
                    --n;
                }
            }
            n = n3;
            while (n < pointerTargetNodeArray2.length) {
                pointerTargetNodeArray2[n].setType(relationship.getType().getSymmetricType());
                pointerTargetNodeList.add(pointerTargetNodeArray2[n]);
                ++n;
            }
            return new AsymmetricRelationship(pointerTargetNodeList, n4, relationship);
        }
        return null;
    }
}

