/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.Sequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class FeatureSequence
implements Sequence,
Serializable {
    Alphabet dictionary;
    int[] features;
    int length;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public FeatureSequence(Alphabet dict, int[] features) {
        this(dict, features.length);
        int i = 0;
        while (i < features.length) {
            this.add(features[i]);
            ++i;
        }
    }

    public FeatureSequence(Alphabet dict, int[] features, int len) {
        this(dict, len);
        int i = 0;
        while (i < len) {
            this.add(features[i]);
            ++i;
        }
    }

    public FeatureSequence(Alphabet dict, int capacity) {
        this.dictionary = dict;
        this.features = new int[capacity > 2 ? capacity : 2];
        this.length = 0;
    }

    public FeatureSequence(Alphabet dict) {
        this(dict, 2);
    }

    public Alphabet getAlphabet() {
        return this.dictionary;
    }

    public final int getLength() {
        return this.length;
    }

    public final int size() {
        return this.length;
    }

    public final int getIndexAtPosition(int pos) {
        return this.features[pos];
    }

    public Object getObjectAtPosition(int pos) {
        return this.dictionary.lookupObject(this.features[pos]);
    }

    public Object get(int pos) {
        return this.dictionary.lookupObject(this.features[pos]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int fsi = 0;
        while (fsi < this.length) {
            Object o = this.dictionary.lookupObject(this.features[fsi]);
            sb.append(fsi);
            sb.append(": ");
            sb.append(o.toString());
            sb.append(" (");
            sb.append(this.features[fsi]);
            sb.append(")\n");
            ++fsi;
        }
        return sb.toString();
    }

    protected void growIfNecessary() {
        if (this.length == this.features.length) {
            int[] newFeatures = new int[this.features.length * 2];
            System.arraycopy(this.features, 0, newFeatures, 0, this.length);
            this.features = newFeatures;
        }
    }

    public void add(int featureIndex) {
        this.growIfNecessary();
        assert (featureIndex < this.dictionary.size());
        this.features[this.length++] = featureIndex;
    }

    public void add(Object key) {
        int fi = this.dictionary.lookupIndex(key);
        if (fi >= 0) {
            this.add(fi);
        }
    }

    public void addFeatureWeightsTo(double[] weights) {
        int i = 0;
        while (i < this.length) {
            int n = this.features[i];
            weights[n] = weights[n] + 1.0;
            ++i;
        }
    }

    public void addFeatureWeightsTo(double[] weights, double scale) {
        int i = 0;
        while (i < this.length) {
            int n = this.features[i];
            weights[n] = weights[n] + scale;
            ++i;
        }
    }

    public int[] toFeatureIndexSequence() {
        int[] feats = new int[this.length];
        System.arraycopy(this.features, 0, feats, 0, this.length);
        return feats;
    }

    public int[] toSortedFeatureIndexSequence() {
        int[] feats = this.toFeatureIndexSequence();
        Arrays.sort(feats);
        return feats;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.dictionary);
        out.writeInt(this.features.length);
        int i = 0;
        while (i < this.features.length) {
            out.writeInt(this.features[i]);
            ++i;
        }
        out.writeInt(this.length);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.dictionary = (Alphabet)in.readObject();
        int featuresLength = in.readInt();
        this.features = new int[featuresLength];
        int i = 0;
        while (i < featuresLength) {
            this.features[i] = in.readInt();
            ++i;
        }
        this.length = in.readInt();
    }
}

