/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.AnnotationColor;
import Jet.Tipster.AnnotationColorEntry;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSplitter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class AnnotationTool
extends JFrame {
    private Document document;
    StyledDocument styledDocument;
    StyledDocument styledInstructionDocument;
    private Annotation[] tokens;
    private boolean[] tagged;
    private Annotation[] newAnnotation;
    private int dot;
    private int mark;
    private boolean quit = false;
    private int start;
    private int length;
    private JSplitPane splitPane = new JSplitPane(0);
    private JTextPane textPane = new JTextPane();
    private JTextPane instructionPane = new JTextPane();
    private JScrollPane scrollPane1 = new JScrollPane();
    private JScrollPane scrollPane2 = new JScrollPane();
    private TitledBorder border = new TitledBorder("quack");
    private Keymap keymap;
    private ArrayList actions = new ArrayList();
    private String instructions = "";

    public AnnotationTool() {
        try {
            this.initTool();
            this.setTitle("AnnotationTool");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initTool() {
        this.textPane.setEditable(false);
        this.keymap = JTextComponent.addKeymap("AnnotationToolMap", null);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(37, 0);
        this.keymap.addActionForKeyStroke(keyStroke, new SelectionAction("left"));
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(39, 0);
        this.keymap.addActionForKeyStroke(keyStroke2, new SelectionAction("right"));
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(37, 1);
        this.keymap.addActionForKeyStroke(keyStroke3, new SelectionAction("shiftLeft"));
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(39, 1);
        this.keymap.addActionForKeyStroke(keyStroke4, new SelectionAction("shiftRight"));
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke('u');
        this.keymap.addActionForKeyStroke(keyStroke5, new UndoAction());
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke('q');
        this.keymap.addActionForKeyStroke(keyStroke6, new QuitAction(this, false));
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke('Q');
        this.keymap.addActionForKeyStroke(keyStroke7, new QuitAction(this, true));
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke(' ');
        this.keymap.addActionForKeyStroke(keyStroke8, new ScrollAction());
        this.textPane.setKeymap(this.keymap);
        AnnotationToolMouseListener annotationToolMouseListener = new AnnotationToolMouseListener();
        this.textPane.addMouseListener(annotationToolMouseListener);
        this.scrollPane1.getViewport().add(this.textPane);
        this.splitPane.setTopComponent(this.scrollPane1);
        this.scrollPane2.getViewport().add(this.instructionPane);
        this.splitPane.setBottomComponent(this.scrollPane2);
        this.splitPane.setResizeWeight(0.8);
        this.border.setTitlePosition(5);
        this.scrollPane1.setBorder(this.border);
        this.setSize(600, 400);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.addWindowListener(new AnnotationToolWindowListener(this));
    }

    public void addType(char c, Annotation annotation) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
        AddAnnotationAction addAnnotationAction = new AddAnnotationAction(c, annotation);
        this.keymap.addActionForKeyStroke(keyStroke, addAnnotationAction);
        this.actions.add(addAnnotationAction);
        this.instructions = this.instructions + addAnnotationAction.instruction + "\n";
    }

    public synchronized boolean annotateDocument(Document document, Span span) {
        Serializable serializable;
        this.document = document;
        this.textPane.setText(this.document.text().toString());
        this.styledDocument = this.textPane.getStyledDocument();
        this.instructionPane.setText(this.instructions);
        this.styledInstructionDocument = this.instructionPane.getStyledDocument();
        int n = 0;
        for (int i = 0; i < this.actions.size(); ++i) {
            serializable = (AddAnnotationAction)this.actions.get(i);
            int n2 = ((AddAnnotationAction)serializable).instruction.length();
            this.styledInstructionDocument.setCharacterAttributes(n, n2, ((AddAnnotationAction)serializable).colorAttribute, true);
            n += n2 + 1;
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBold(simpleAttributeSet, true);
        this.start = span.start();
        this.length = span.endNoWS(this.document) - this.start;
        this.styledDocument.setCharacterAttributes(this.start, this.length, simpleAttributeSet, true);
        this.tokens = Tokenizer.gatherTokens(this.document, span);
        if (this.tokens.length == 0) {
            System.out.println("Can't annotate document:  not tokenized");
            return false;
        }
        this.tagged = new boolean[this.tokens.length];
        this.newAnnotation = new Annotation[this.tokens.length];
        this.markPreAnnotations();
        this.dot = 0;
        this.mark = 0;
        this.highlightSelection(true);
        if (document instanceof ExternalDocument) {
            serializable = (ExternalDocument)document;
            String string = ((ExternalDocument)serializable).fileName();
            this.setTitle("AnnotationTool:  " + string);
        }
        this.setVisible(true);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.quit;
    }

    private void markPreAnnotations() {
        for (int i = 0; i < this.tokens.length; ++i) {
            Annotation annotation = this.tokens[i];
            int n = annotation.start();
            int n2 = annotation.end();
            Vector<Annotation> vector = this.document.annotationsAt(n);
            block1: for (int j = 0; j < vector.size(); ++j) {
                Annotation annotation2 = vector.get(j);
                for (int k = 0; k < this.actions.size(); ++k) {
                    AddAnnotationAction addAnnotationAction = (AddAnnotationAction)this.actions.get(k);
                    if (!annotation2.type().equals(addAnnotationAction.annotationType) || !addAnnotationAction.fs.subsetOf(annotation2.attributes())) continue;
                    int n3 = i;
                    while (this.tokens[n3].span().end() <= n2) {
                        this.tagged[n3] = true;
                        ++n3;
                    }
                    this.newAnnotation[i] = annotation2;
                    this.border.setTitle(annotation2.toString());
                    this.scrollPane1.repaint();
                    n3 = annotation2.span().endNoWS(this.document) - n;
                    this.styledDocument.setCharacterAttributes(n, n3, addAnnotationAction.colorAttribute, false);
                    continue block1;
                }
            }
        }
    }

    private void highlightSelection(boolean bl) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setUnderline(simpleAttributeSet, bl);
        int n = Math.min(this.dot, this.mark);
        int n2 = Math.max(this.dot, this.mark);
        int n3 = this.tokens[n].span().start();
        int n4 = this.tokens[n2].span().endNoWS(this.document) - n3;
        this.styledDocument.setCharacterAttributes(n3, n4, simpleAttributeSet, false);
        Annotation annotation = this.newAnnotation[n];
        if (bl) {
            this.border.setTitle(annotation == null ? " " : annotation.toString());
            this.scrollPane1.repaint();
        }
    }

    String[] addTypes(AnnotationColor annotationColor) {
        ArrayList<AnnotationColorEntry> arrayList = AnnotationColor.colors;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnotationColorEntry annotationColorEntry = arrayList.get(i);
            Annotation annotation = new Annotation(annotationColorEntry.type, null, new FeatureSet(annotationColorEntry.feature, annotationColorEntry.featureValue));
            char c = annotationColorEntry.key;
            this.addType(c, annotation);
            hashSet.add(annotationColorEntry.type);
        }
        String[] stringArray = hashSet.toArray(new String[0]);
        return stringArray;
    }

    public static void main(String[] stringArray) {
        Span span;
        Object object;
        if (stringArray.length != 2) {
            System.err.println("AnnotationTool requires two arguments:  document  colorFile");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        AnnotationColor annotationColor = new AnnotationColor(".", string2);
        AnnotationColor.showColors();
        AnnotationTool annotationTool = new AnnotationTool();
        String[] stringArray2 = annotationTool.addTypes(annotationColor);
        JetTest.encoding = "UTF-8";
        ExternalDocument externalDocument = new ExternalDocument("sgml", string);
        externalDocument.setSGMLtags(stringArray2);
        externalDocument.open();
        externalDocument.annotateWithTag("TEXT");
        Vector<Annotation> vector = externalDocument.annotationsOfType("TEXT");
        if (vector != null && vector.size() > 0) {
            object = vector.get(0);
            span = ((Annotation)object).span();
        } else {
            span = externalDocument.fullSpan();
        }
        SentenceSplitter.split(externalDocument, span);
        object = externalDocument.annotationsOfType("sentence");
        if (object == null) {
            return;
        }
        Iterator iterator = ((Vector)object).iterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            Span span2 = annotation.span();
            Tokenizer.tokenize(externalDocument, span2);
        }
        annotationTool.annotateDocument(externalDocument, span);
        externalDocument.removeAnnotationsOfType("token");
        externalDocument.shrinkAll();
        externalDocument.setSGMLwrapMargin(0);
        externalDocument.save();
        System.exit(0);
    }

    int findToken(int n) {
        if (n < 0) {
            return n;
        }
        for (int i = 0; i < this.tokens.length; ++i) {
            if (n < this.tokens[i].start() || n >= this.tokens[i].end()) continue;
            return i;
        }
        return -1;
    }

    class AnnotationToolMouseListener
    implements MouseListener {
        AnnotationToolMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = AnnotationTool.this.textPane.viewToModel(point);
            int n2 = AnnotationTool.this.findToken(n);
            if (n2 >= 0) {
                AnnotationTool.this.highlightSelection(false);
                AnnotationTool.this.dot = n2;
                AnnotationTool.this.mark = n2;
                AnnotationTool.this.highlightSelection(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = AnnotationTool.this.textPane.viewToModel(point);
            int n2 = AnnotationTool.this.findToken(n);
            if (n2 >= 0) {
                AnnotationTool.this.highlightSelection(false);
                AnnotationTool.this.mark = n2;
                AnnotationTool.this.highlightSelection(true);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class AnnotationToolWindowListener
    extends WindowAdapter {
        AnnotationTool tool;

        public AnnotationToolWindowListener(AnnotationTool annotationTool2) {
            this.tool = annotationTool2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosing(WindowEvent windowEvent) {
            AnnotationTool.this.dispose();
            AnnotationTool annotationTool = this.tool;
            synchronized (annotationTool) {
                this.tool.notify();
            }
        }
    }

    class AddAnnotationAction
    extends AbstractAction {
        char keychar;
        String annotationType;
        FeatureSet fs;
        Color color;
        SimpleAttributeSet colorAttribute;
        String instruction;

        AddAnnotationAction(char c, Annotation annotation) {
            this.keychar = c;
            this.annotationType = annotation.type();
            this.fs = annotation.attributes();
            Color color = AnnotationColor.getColor(annotation);
            this.colorAttribute = new SimpleAttributeSet();
            StyleConstants.setBackground(this.colorAttribute, color);
            this.instruction = this.keychar + ": " + this.annotationType;
            if (this.fs != null) {
                this.instruction = this.instruction + " " + this.fs;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = Math.min(AnnotationTool.this.dot, AnnotationTool.this.mark);
            int n3 = Math.max(AnnotationTool.this.dot, AnnotationTool.this.mark);
            for (n = n2; n <= n3; ++n) {
                if (!AnnotationTool.this.tagged[n]) continue;
                JOptionPane.showMessageDialog(null, "Can't add annotation:\nselection already has annotation", "Error", 0);
                return;
            }
            for (n = n2; n <= n3; ++n) {
                ((AnnotationTool)AnnotationTool.this).tagged[n] = true;
            }
            n = AnnotationTool.this.tokens[n2].span().start();
            int n4 = AnnotationTool.this.tokens[n3].span().end();
            Annotation annotation = new Annotation(this.annotationType, new Span(n, n4), this.fs);
            AnnotationTool.this.document.addAnnotation(annotation);
            ((AnnotationTool)AnnotationTool.this).newAnnotation[n2] = annotation;
            AnnotationTool.this.border.setTitle(annotation.toString());
            AnnotationTool.this.scrollPane1.repaint();
            int n5 = AnnotationTool.this.tokens[n3].span().endNoWS(AnnotationTool.this.document) - n;
            AnnotationTool.this.styledDocument.setCharacterAttributes(n, n5, this.colorAttribute, false);
        }
    }

    class QuitAction
    extends AbstractAction {
        AnnotationTool tool;
        boolean stopLearner;

        public QuitAction(AnnotationTool annotationTool2, boolean bl) {
            this.tool = annotationTool2;
            this.stopLearner = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationTool.this.dispose();
            if (this.stopLearner) {
                AnnotationTool.this.quit = true;
            }
            AnnotationTool annotationTool = this.tool;
            synchronized (annotationTool) {
                this.tool.notify();
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = Math.min(AnnotationTool.this.dot, AnnotationTool.this.mark);
            int n3 = Math.max(AnnotationTool.this.dot, AnnotationTool.this.mark);
            int n4 = AnnotationTool.this.tokens[n2].span().start();
            int n5 = AnnotationTool.this.tokens[n3].span().end();
            Annotation annotation = AnnotationTool.this.newAnnotation[n2];
            if (annotation == null || annotation.span().end() != n5) {
                JOptionPane.showMessageDialog(null, "Can't undo:\nselection doesn't correspond to annotation", "Error", 0);
                return;
            }
            ((AnnotationTool)AnnotationTool.this).newAnnotation[n2] = null;
            for (n = n2; n <= n3; ++n) {
                ((AnnotationTool)AnnotationTool.this).tagged[n] = false;
            }
            AnnotationTool.this.document.removeAnnotation(annotation);
            n = AnnotationTool.this.tokens[n3].span().endNoWS(AnnotationTool.this.document) - n4;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBackground(simpleAttributeSet, Color.white);
            AnnotationTool.this.styledDocument.setCharacterAttributes(n4, n, simpleAttributeSet, false);
            AnnotationTool.this.border.setTitle(" ");
            AnnotationTool.this.scrollPane1.repaint();
        }
    }

    class SelectionAction
    extends AbstractAction {
        String key;

        SelectionAction(String string) {
            this.key = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationTool.this.highlightSelection(false);
            if (this.key == "left") {
                if (AnnotationTool.this.dot > 0) {
                    AnnotationTool.this.dot--;
                }
                AnnotationTool.this.mark = AnnotationTool.this.dot;
            } else if (this.key == "right") {
                if (AnnotationTool.this.dot < AnnotationTool.this.tokens.length - 1) {
                    AnnotationTool.this.dot++;
                }
                AnnotationTool.this.mark = AnnotationTool.this.dot;
            } else if (this.key == "shiftLeft") {
                if (AnnotationTool.this.dot > 0) {
                    AnnotationTool.this.dot--;
                }
            } else if (this.key == "shiftRight" && AnnotationTool.this.dot < AnnotationTool.this.tokens.length - 1) {
                AnnotationTool.this.dot++;
            }
            AnnotationTool.this.highlightSelection(true);
        }
    }

    class ScrollAction
    extends AbstractAction {
        ScrollAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Rectangle rectangle = AnnotationTool.this.textPane.modelToView(AnnotationTool.this.start + AnnotationTool.this.length);
                AnnotationTool.this.textPane.scrollRectToVisible(rectangle);
            }
            catch (BadLocationException badLocationException) {
                System.out.println("AnnotationTool:  invalid selected sentence");
            }
        }
    }
}

