/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.NE.BioType;
import Jet.NE.ChangeRule;
import Jet.NE.ChangeType;
import Jet.NE.ClassRule;
import Jet.NE.MatchRuleItem;
import Jet.NE.MatchType;
import Jet.NE.NamedEntityAttribute;
import Jet.NE.NamedEntityRule;
import Jet.NE.PartOfSpeechRule;
import Jet.NE.RegexpRule;
import Jet.NE.RuleFormatException;
import Jet.NE.StringRule;
import Jet.NE.TransformRule;
import Jet.Util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformRuleParser {
    private static final char PREFIX_CHANGE_FORCE = '!';
    private static final char PREFIX_MATCH_NOT = '!';
    private static final char PREFIX_MATCH_SPECIAL = '~';
    private static final Pattern MATCH_RULE_SEPARATOR = Pattern.compile("\\s+");
    private static final Pattern PATTERN_SEPARATOR = Pattern.compile("\\|");
    private static final int OFFSET_STRING_MATCH_RULE = 0;
    private static final int OFFSET_CLASS_MATCH_RULE = 1;
    private static final int OFFSET_POS_MATCH_RULE = 2;
    private static final int OFFSET_NE_MATCH_RULE = 3;
    private static final int OFFSET_RE_MATCH_RULE = 4;
    private static final String PREFIX_NE_BIO_B = "B-";
    private static final String PREFIX_NE_BIO_I = "I-";
    private static final String NE_BIO_O = "O";

    public List<TransformRule> parse(Reader reader) throws IOException, RuleFormatException {
        String string;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        ArrayList<TransformRule> arrayList = new ArrayList<TransformRule>();
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(35);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((string = string.trim()).length() <= 0) continue;
            arrayList.add(this.parseLine(string));
        }
        return arrayList;
    }

    private TransformRule parseLine(String string) throws RuleFormatException {
        int n = string.indexOf(62);
        if (n < 0) {
            throw new RuleFormatException("change rule not.");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        ChangeType changeType = ChangeType.NORMAL;
        if (string3.charAt(0) == '!') {
            changeType = ChangeType.FORCE;
            string3 = string3.substring(1).trim();
        }
        TransformRule transformRule = new TransformRule();
        transformRule.setMatchRules(this.parseMatchRule(string2));
        transformRule.setChangeRule(changeType, this.parseChangeRule(string3));
        return transformRule;
    }

    private MatchRuleItem[] parseMatchRule(String string) throws RuleFormatException {
        Pattern pattern = Pattern.compile("\\s*\\((.*?)\\)\\s*");
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.regionStart() < string.length()) {
            if (!matcher.lookingAt()) {
                throw new RuleFormatException("Ilegral matching rule.");
            }
            arrayList.add(matcher.group(1));
            matcher.region(matcher.end(), matcher.regionEnd());
        }
        MatchRuleItem[] matchRuleItemArray = new MatchRuleItem[arrayList.size()];
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            matchRuleItemArray[i] = this.parseMatchRuleItem((String)arrayList.get(i));
        }
        return matchRuleItemArray;
    }

    private ChangeRule[] parseChangeRule(String string) throws RuleFormatException {
        String[] stringArray = string.split("\\s+");
        ChangeRule[] changeRuleArray = new ChangeRule[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int n2 = stringArray[i].indexOf(61);
            if (n2 < 0) {
                throw new RuleFormatException();
            }
            String string2 = stringArray[i].substring(0, n2).trim();
            try {
                n = Integer.parseInt(string2) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuleFormatException('\"' + string2 + "\" is not number");
            }
            if (n < 0) {
                throw new RuleFormatException('\"' + string2 + "\" is invalid number");
            }
            String string3 = stringArray[i].substring(n2 + 1).trim();
            NamedEntityAttribute namedEntityAttribute = this.parseNamedEntityExpression(string3);
            changeRuleArray[i] = new ChangeRule(n, namedEntityAttribute);
        }
        return changeRuleArray;
    }

    private MatchRuleItem parseMatchRuleItem(String string) throws RuleFormatException {
        String[] stringArray = MATCH_RULE_SEPARATOR.split(string);
        MatchRuleItem matchRuleItem = new MatchRuleItem();
        block11: for (int i = 0; i < stringArray.length; ++i) {
            MatchType matchType;
            if (stringArray[i].equals("*")) continue;
            if (stringArray[i].length() == 0) {
                throw new RuleFormatException();
            }
            String string2 = stringArray[i];
            switch (string2.charAt(0)) {
                case '!': {
                    string2 = string2.substring(1);
                    matchType = MatchType.NOT;
                    break;
                }
                case '~': {
                    string2 = string2.substring(1);
                    matchType = MatchType.SPECIAL;
                    break;
                }
                default: {
                    matchType = MatchType.NORMAL;
                }
            }
            String[] stringArray2 = PATTERN_SEPARATOR.split(string2);
            switch (i) {
                case 0: {
                    matchRuleItem.setStringRule(this.parseStringRule(matchType, stringArray2));
                    continue block11;
                }
                case 1: {
                    matchRuleItem.setClassRule(this.parseClassRule(matchType, stringArray2));
                    continue block11;
                }
                case 2: {
                    matchRuleItem.setPartOfSpeechRule(this.parsePartOfSpeechRule(matchType, stringArray2));
                    continue block11;
                }
                case 3: {
                    matchRuleItem.setNamedEntityRule(this.parseNamedEntityRule(matchType, stringArray2));
                    continue block11;
                }
                case 4: {
                    matchRuleItem.setRegexpRule(this.parseRegexpRule(matchType, stringArray2));
                    continue block11;
                }
                default: {
                    throw new RuleFormatException();
                }
            }
        }
        return matchRuleItem;
    }

    private StringRule parseStringRule(MatchType matchType, String[] stringArray) throws RuleFormatException {
        switch (matchType) {
            case NORMAL: 
            case NOT: 
            case ANY: {
                return new StringRule(matchType, stringArray);
            }
        }
        throw new RuleFormatException();
    }

    private ClassRule parseClassRule(MatchType matchType, String[] stringArray) throws RuleFormatException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("N-")) continue;
            stringArray[i] = stringArray[i].substring(2);
        }
        switch (matchType) {
            case NORMAL: 
            case NOT: 
            case ANY: {
                return new ClassRule(matchType, stringArray);
            }
            case SPECIAL: {
                if (stringArray.length == 1) {
                    return new ClassRule(matchType, stringArray);
                }
                throw new RuleFormatException();
            }
        }
        throw new RuleFormatException();
    }

    private PartOfSpeechRule parsePartOfSpeechRule(MatchType matchType, String[] stringArray) throws RuleFormatException {
        switch (matchType) {
            case NORMAL: 
            case NOT: 
            case ANY: {
                return new PartOfSpeechRule(matchType, stringArray);
            }
        }
        throw new RuleFormatException();
    }

    private NamedEntityRule parseNamedEntityRule(MatchType matchType, String[] stringArray) throws RuleFormatException {
        NamedEntityAttribute[] namedEntityAttributeArray = new NamedEntityAttribute[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            namedEntityAttributeArray[i] = this.parseNamedEntityExpression(stringArray[i]);
        }
        return new NamedEntityRule(matchType, namedEntityAttributeArray);
    }

    private RegexpRule parseRegexpRule(MatchType matchType, String[] stringArray) throws RuleFormatException {
        return new RegexpRule(matchType, StringUtils.join("|", stringArray));
    }

    private NamedEntityAttribute parseNamedEntityExpression(String string) throws RuleFormatException {
        if (string.equals(NE_BIO_O)) {
            return new NamedEntityAttribute(null, BioType.O);
        }
        if (string.startsWith(PREFIX_NE_BIO_B)) {
            String string2 = string.substring(PREFIX_NE_BIO_B.length());
            return new NamedEntityAttribute(string2, BioType.B);
        }
        if (string.startsWith(PREFIX_NE_BIO_I)) {
            String string3 = string.substring(PREFIX_NE_BIO_I.length());
            return new NamedEntityAttribute(string3, BioType.I);
        }
        throw new RuleFormatException('\"' + string + "\" is not named entity name");
    }
}

