/*
 * Decompiled with CFR 0.152.
 */
package Jet.Chunk;

import AceJet.Ace;
import Jet.Chunk.MaxEntNE;
import Jet.Chunk.Onoma;
import Jet.HMM.HMMNameTagger;
import Jet.HMM.HMMannotator;
import Jet.JetTest;
import Jet.Lex.Lexicon;
import Jet.Lex.Tokenizer;
import Jet.Scorer.NameTagger;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSplitter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class MENameTagger
implements NameTagger {
    public MaxEntNE mene = new MaxEntNE();
    HMMannotator annotator = new HMMannotator(this.mene);

    public MENameTagger() {
        this.annotator.setBItag(true);
        this.annotator.setAnnotateEachToken(false);
    }

    public void initialize(String string, String string2) {
        this.mene.resetForTraining(string2);
        this.annotator.readTagTable(string);
    }

    public void train(String string) throws IOException {
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            this.train(externalDocument);
        }
    }

    public void train(ExternalDocument externalDocument) {
        externalDocument.setAllTags(true);
        externalDocument.open();
        externalDocument.stretchAll();
        System.out.println("Training from " + externalDocument.fileName());
        this.mene.newDocument();
        Vector<Annotation> vector = externalDocument.annotationsOfType("TEXT");
        if (vector == null) {
            return;
        }
        for (Annotation object : vector) {
            Span span = object.span();
            Ace.monocase = Ace.allLowerCase(externalDocument);
            SentenceSplitter.split(externalDocument, span);
        }
        Vector<Annotation> vector2 = externalDocument.annotationsOfType("sentence");
        if (vector2 == null) {
            return;
        }
        for (Annotation annotation : vector2) {
            Span span = annotation.span();
            Tokenizer.tokenize(externalDocument, span);
            Lexicon.annotateWithDefinitions(externalDocument, span.start(), span.end());
            this.annotator.trainOnSpan(externalDocument, span);
        }
        externalDocument.clearAnnotations();
    }

    public void train(String string, String string2) throws IOException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            System.out.println("\nTraining from document " + ++n + ": " + string3);
            ExternalDocument externalDocument = new ExternalDocument("sgml", string, string3);
            this.train(externalDocument);
        }
    }

    public void store(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), JetTest.encoding));
        this.annotator.writeTagTable(bufferedWriter);
        bufferedWriter.write("endtags");
        bufferedWriter.newLine();
        this.mene.store(bufferedWriter);
    }

    public void load(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), JetTest.encoding));
        this.annotator.readTagTable(bufferedReader);
        this.mene.load(bufferedReader);
    }

    public void tagDocument(Document document) {
        this.mene.newDocument();
        Vector<Annotation> vector = document.annotationsOfType("TEXT");
        for (Annotation object22 : vector) {
            Span span = object22.span();
            SentenceSplitter.split(document, span);
        }
        Vector<Annotation> vector2 = document.annotationsOfType("sentence");
        for (Annotation annotation : vector2) {
            Span span = annotation.span();
            Tokenizer.tokenize(document, span);
            Lexicon.annotateWithDefinitions(document, span.start(), span.end());
            this.tag(document, span);
        }
    }

    public void newDocument() {
        this.mene.newDocument();
    }

    public void tag(Document document, Span span) {
        if (HMMNameTagger.inZone(document, span, "POSTER") || HMMNameTagger.inZone(document, span, "SPEAKER")) {
            HMMNameTagger.tagPersonZone(document, span, this.annotator);
        } else {
            this.annotator.annotateSpan(document, span);
            Onoma.tagDrugs(document, span);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 6 || stringArray.length % 2 == 1) {
            System.err.println("MENameTagger requires 4 + 2n arguments for n training corpora:");
            System.err.println("  state-file feature-file model-file props-file directory1 filelist1 [directory2 filelist2] ...");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        JetTest.initializeFromConfig(string4);
        MENameTagger mENameTagger = new MENameTagger();
        mENameTagger.initialize(string, string2);
        for (int i = 1; i <= 2; ++i) {
            MaxEntNE.pass = i;
            MaxEntNE.trainingDocCount = 0;
            for (int j = 4; j < stringArray.length; j += 2) {
                String string5 = stringArray[j];
                String string6 = stringArray[j + 1];
                mENameTagger.train(string5, string6);
            }
        }
        mENameTagger.mene.createModel();
        mENameTagger.store(string3);
    }
}

