/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEvent;
import AceJet.AceEventMention;
import AceJet.AceEventMentionArgument;
import AceJet.AceMention;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventScorer {
    static String textDirectory;
    static String textExtension;
    static String systemApfDirectory;
    static String systemApfExtension;
    static String keyApfDirectory;
    static String keyApfExtension;
    static int correctTriggers;
    static int spuriousTriggers;
    static int missingTriggers;
    static float triggerRecall;
    static float triggerPrecision;
    static float triggerF;
    static int correctArguments;
    static int spuriousArguments;
    static int missingArguments;
    static float argumentRecall;
    static float argumentPrecision;
    static float argumentF;
    static int correctRoles;
    static int spuriousRoles;
    static int missingRoles;
    static float roleRecall;
    static float rolePrecision;
    static float roleF;

    public static void main(String[] stringArray) throws IOException {
        String string;
        if (stringArray.length != 7) {
            System.out.println("EventScorer requires 7 args:  ");
            System.out.print("    docList textDirectory textExtension ");
            System.out.println("systemApfDirectory systemApfExtension keyApfDirectory keyApfExtension");
            System.exit(1);
        }
        String string2 = stringArray[0];
        textDirectory = stringArray[1];
        textExtension = stringArray[2];
        systemApfDirectory = stringArray[3];
        systemApfExtension = stringArray[4];
        keyApfDirectory = stringArray[5];
        keyApfExtension = stringArray[6];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        while ((string = bufferedReader.readLine()) != null) {
            EventScorer.scoreDocument(string);
        }
        EventScorer.computeScores();
        EventScorer.reportScores();
    }

    public static void scoreDocument(String string) {
        String string2 = textDirectory + "/" + string + "." + textExtension;
        ExternalDocument externalDocument = new ExternalDocument("sgml", string2);
        externalDocument.setAllTags(true);
        externalDocument.open();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        String string3 = systemApfDirectory + "/" + string + "." + systemApfExtension;
        EventScorer.readApf(string2, string3, hashSet, hashSet2, hashSet3);
        HashSet<String> hashSet4 = new HashSet<String>();
        HashSet<String> hashSet5 = new HashSet<String>();
        HashSet<String> hashSet6 = new HashSet<String>();
        String string4 = keyApfDirectory + "/" + string + "." + keyApfExtension;
        EventScorer.readApf(string2, string4, hashSet4, hashSet5, hashSet6);
        int n = EventScorer.sizeOfSetIntersection(hashSet, hashSet4);
        int n2 = EventScorer.sizeOfSetDifference(hashSet, hashSet4);
        int n3 = EventScorer.sizeOfSetDifference(hashSet4, hashSet);
        int n4 = EventScorer.sizeOfSetIntersection(hashSet2, hashSet5);
        int n5 = EventScorer.sizeOfSetDifference(hashSet2, hashSet5);
        int n6 = EventScorer.sizeOfSetDifference(hashSet5, hashSet2);
        int n7 = EventScorer.sizeOfSetIntersection(hashSet3, hashSet6);
        int n8 = EventScorer.sizeOfSetDifference(hashSet3, hashSet6);
        int n9 = EventScorer.sizeOfSetDifference(hashSet6, hashSet3);
        correctTriggers += n;
        spuriousTriggers += n2;
        missingTriggers += n3;
        correctArguments += n4;
        spuriousArguments += n5;
        missingArguments += n6;
        correctRoles += n7;
        spuriousRoles += n8;
        missingRoles += n9;
    }

    static void readApf(String string, String string2, Set<String> set, Set<String> set2, Set<String> set3) {
        AceDocument aceDocument = new AceDocument(string, string2);
        for (AceEvent aceEvent : aceDocument.events) {
            String string3 = aceEvent.type + ":" + aceEvent.subtype;
            for (AceEventMention aceEventMention : aceEvent.mentions) {
                Span span = aceEventMention.anchorJetExtent;
                set.add(string3 + ":" + span);
                for (AceEventMentionArgument aceEventMentionArgument : aceEventMention.arguments) {
                    AceMention aceMention = aceEventMentionArgument.value;
                    set2.add(string3 + ":" + aceMention.getJetHead());
                    set3.add(string3 + ":" + aceEventMentionArgument.role + ":" + aceMention.getJetHead());
                }
            }
        }
    }

    static void computeScores() {
        triggerRecall = (float)correctTriggers / (float)(correctTriggers + missingTriggers);
        triggerPrecision = (float)correctTriggers / (float)(correctTriggers + spuriousTriggers);
        triggerF = 2.0f * triggerPrecision * triggerRecall / (triggerPrecision + triggerRecall);
        argumentRecall = (float)correctArguments / (float)(correctArguments + missingArguments);
        argumentPrecision = (float)correctArguments / (float)(correctArguments + spuriousArguments);
        argumentF = 2.0f * argumentPrecision * argumentRecall / (argumentPrecision + argumentRecall);
        roleRecall = (float)correctRoles / (float)(correctRoles + missingRoles);
        rolePrecision = (float)correctRoles / (float)(correctRoles + spuriousRoles);
        roleF = 2.0f * rolePrecision * roleRecall / (rolePrecision + roleRecall);
    }

    static int sizeOfSetIntersection(Set set, Set set2) {
        HashSet hashSet = new HashSet(set);
        hashSet.retainAll(set2);
        return hashSet.size();
    }

    static int sizeOfSetDifference(Set set, Set set2) {
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(set2);
        return hashSet.size();
    }

    static void reportScores() {
        System.out.printf("Triggers:   R = %6.2f   P = %6.2f   F = %6.2f\n", Float.valueOf(triggerRecall * 100.0f), Float.valueOf(triggerPrecision * 100.0f), Float.valueOf(triggerF * 100.0f));
        System.out.printf("Arguments:  R = %6.2f   P = %6.2f   F = %6.2f\n", Float.valueOf(argumentRecall * 100.0f), Float.valueOf(argumentPrecision * 100.0f), Float.valueOf(argumentF * 100.0f));
        System.out.printf("Roles:      R = %6.2f   P = %6.2f   F = %6.2f\n", Float.valueOf(roleRecall * 100.0f), Float.valueOf(rolePrecision * 100.0f), Float.valueOf(roleF * 100.0f));
    }

    static {
        correctTriggers = 0;
        spuriousTriggers = 0;
        missingTriggers = 0;
        correctArguments = 0;
        spuriousArguments = 0;
        missingArguments = 0;
        correctRoles = 0;
        spuriousRoles = 0;
        missingRoles = 0;
    }
}

