/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import opennlp.model.AbstractModel;
import opennlp.model.BinaryFileDataReader;
import opennlp.model.Context;
import opennlp.model.DataReader;
import opennlp.model.PlainTextFileDataReader;

public abstract class AbstractModelReader {
    protected int NUM_PREDS;
    protected DataReader dataReader;

    public AbstractModelReader(File file) throws IOException {
        InputStream inputStream;
        String string = file.getName();
        if (string.endsWith(".gz")) {
            inputStream = new GZIPInputStream(new FileInputStream(file));
            string = string.substring(0, string.length() - 3);
        } else {
            inputStream = new FileInputStream(file);
        }
        this.dataReader = string.endsWith(".bin") ? new BinaryFileDataReader(inputStream) : new PlainTextFileDataReader(inputStream);
    }

    public AbstractModelReader(DataReader dataReader) {
        this.dataReader = dataReader;
    }

    public int readInt() throws IOException {
        return this.dataReader.readInt();
    }

    public double readDouble() throws IOException {
        return this.dataReader.readDouble();
    }

    public String readUTF() throws IOException {
        return this.dataReader.readUTF();
    }

    public AbstractModel getModel() throws IOException {
        this.checkModelType();
        return this.constructModel();
    }

    public abstract void checkModelType() throws IOException;

    public abstract AbstractModel constructModel() throws IOException;

    protected String[] getOutcomes() throws IOException {
        int n = this.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readUTF();
        }
        return stringArray;
    }

    protected int[][] getOutcomePatterns() throws IOException {
        int n = this.readInt();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.readUTF(), " ");
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            nArrayArray[i] = nArray;
        }
        return nArrayArray;
    }

    protected String[] getPredicates() throws IOException {
        this.NUM_PREDS = this.readInt();
        String[] stringArray = new String[this.NUM_PREDS];
        for (int i = 0; i < this.NUM_PREDS; ++i) {
            stringArray[i] = this.readUTF();
        }
        return stringArray;
    }

    protected Context[] getParameters(int[][] nArray) throws IOException {
        Context[] contextArray = new Context[this.NUM_PREDS];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            int[] nArray2 = new int[nArray[i].length - 1];
            for (n2 = 1; n2 < nArray[i].length; ++n2) {
                nArray2[n2 - 1] = nArray[i][n2];
            }
            for (n2 = 0; n2 < nArray[i][0]; ++n2) {
                double[] dArray = new double[nArray[i].length - 1];
                for (int j = 1; j < nArray[i].length; ++j) {
                    dArray[j - 1] = this.readDouble();
                }
                contextArray[n] = new Context(nArray2, dArray);
                ++n;
            }
        }
        return contextArray;
    }
}

