#!/usr/bin/python
##################################################
#Copyright (c) 2011, David F. Fouhey
#See License.txt
##################################################
#Common code
##################################################


import os, sys 
from tempfile import mkstemp
from math import *

def getTempFilename(suffix='',prefix='tmp',dir=None,text=False):
    """Get a temporary filename"""
    handle, name = mkstemp(suffix=suffix,prefix=prefix,dir=dir,text=text)
    os.close(handle)
    return name

def ED(p,q):
    """Return the euclidean distance between two points"""
    return ((p[0] - q[0])**2 + (p[1] - q[1])**2)**0.5


def int2Color(id1):
    """Map an integer to a color; kudos to Daniel Scharstein for this""" 
    id = id1+1
    j = 7
    R,G,B = 0,0,0
    while j  >= 0:
        R |= ((id >> 0) & 1) << j
        G |= ((id >> 1) & 1) << j
        B |= ((id >> 2) & 1) << j
        id >>= 3
        j -= 1
    return (R,G,B)

#Kudos to Wikipedia 
#   http://en.wikipedia.org/wiki/Algorithms_for_calculating_variance
#and therefore to Knuth, and therefore to Welford
#for the one-pass standard deviation calculator.
#
#Returns a 2-tuple containing the mean and the standard
#deviation of the given enumerable of numbers
def getMeanAndSDev(nums):
    """Return the mean and standard deviation of the given numerical iterable"""
    mean = 0.0
    var = 0.0
    n = 0
    for x in nums:
        xf = float(x)
        n += 1
        delta = xf - mean
        mean += delta / n
        var += delta*(x-mean)
    return (mean, sqrt(var / (n-1)))

