#!/usr/bin/python
##################################################
#Copyright (c) 2011, David F. Fouhey
#See License.txt
##################################################
#Stability Test Code
##################################################

from common import *
from homography import *
from random import *

def median(S):
    Sp = [v for v in S]
    Sp.sort()
    return Sp[len(Sp) / 2] if len(Sp) % 2 == 1 else (Sp[len(Sp)/2 - 1] + Sp[len(Sp)/2]) / 2

def ShakeTest(matches, shakeCount):
    """Perform the probabilistic shake test"""
    #get the bounding box in image 0
    X, Y = [m[0] for m in matches], [m[1] for m in matches]
    minX, maxX, minY, maxY = min(X), max(X), min(Y), max(Y)
    xRange, yRange = maxX - minX, maxY - minY

    #get the scale of the perturbation noise; this needs to be scaled to the 
    #range of the box
    xSigma, ySigma = xRange / 300.0, yRange / 300.0

    perturbedHomographies = []
    #compute the perturbed transformations
    for shakeNum in range(shakeCount):
        #get the noise

        #apply it to both corresponding feature locations
        perturbedMatches = []
        for x, y, xp, yp in matches:
            xN, yN = gauss(0,xSigma), gauss(0,ySigma)
            perturbedMatches.append((x+xN, y+yN, xp+xN, yp+yN))
      

        perturbedHomographies.append(
            solvePerspective(perturbedMatches)
                                    )
    
    #the corners of the bounding box
    corners = [(minX, minY), (minX, maxY), (maxX, minY), (maxX, maxY)]
    #keep track of x and y for each corner
    cornerProjections = [[] for i in range(len(corners)*2)]

    #collect the projections of the points
    for H in perturbedHomographies:
        for pi,p in enumerate(corners):
            x, y = project(H,p)
            cornerProjections[2*pi+0].append(x)
            cornerProjections[2*pi+1].append(y)
  
    print cornerProjections

    stdDevRatios = []
    #compute their statistics: do the projected perturbed points have more
    #variarance than the introduced noise
    for i in range(len(corners)):
        _mean, projXSigma = getMeanAndSDev(cornerProjections[2*i+0])
        _mean, projYSigma = getMeanAndSDev(cornerProjections[2*i+1])
        stdDevRatios += [projXSigma/xSigma, projYSigma/ySigma]


    #return median(stdDevRatios) 
    return sum(stdDevRatios) / len(stdDevRatios)
    
