#!/usr/bin/python
##################################################
#Copyright (c) 2011, David F. Fouhey
#See License.txt
##################################################
#SIFT Support Code
##################################################

import os, sys
from common import *
from subprocess import *

SIFTExec = "./sift"
keypointMatcherExec = "./keypointMatcher"


def convertToPGMOpenCV(filename):
    """Convert a file to PGM"""
    image = cv.LoadImage(filename, 0)
    cv.SaveImage(filename+".pgm", image)

def convertToPGMImageMagick(filename):
    os.system("convert -strip %s %s.pgm" % (filename, filename))

convertToPGM = convertToPGMOpenCV
try:
    import cv
except:
    convertToPGM = convertToPGMImageMagick

def extractSIFTFeatures(filename):
    """Extract SIFT features"""
    convertToPGM(filename)
    os.system("%s < %s.pgm > %s.keys" % (SIFTExec, filename, filename))

def matchKeypointFiles(kfn0, kfn1, ratio):
    """Match keypoint files and return the keypoint matches"""
    keypoints0 = readSIFTFile(kfn0)
    keypoints1 = readSIFTFile(kfn1)
    matchFile = getTempFilename(suffix=".txt")
    com = "echo \" \" | cat %s - %s | " % (kfn1, kfn0)
    com += keypointMatcherExec+" 128 %d %d %f > %s" % (len(keypoints1), len(keypoints0), ratio, matchFile)
    os.system(com)
    results = []
    for line in file(matchFile):
        #Note the reverse 
        k1i, k0i = map(int,line.split())
        results += [(keypoints0[k0i], keypoints1[k1i])]
    os.remove(matchFile)
    return results 


class SIFTKeypoint:
	#location is a 2-tuple of floats
	#scale is a float
	#rotation is a float
	#descriptor is a 128-item-long list of floats
    def __init__(self, location, scale, rotation, descriptor):
        self.location = location
        self.scale = scale
        self.rotation = rotation
        #self.descriptor = descriptor
        self.descriptor = descriptor

    def __str__(self):
        return str(self.location)+" ; "+str(self.descriptor)

    def __repr__(self):
        return str(self)

def readSIFTFile(filename):
    """Read a SIFT file outputted by the SIFT program"""
    points = []
    f = file(filename,"r")
    data = map(float, f.read().split())
    i = 2
    #start on the 3rd item
    while i < len(data):
        points.append( SIFTKeypoint(	(data[i+1],data[i]),
                                         data[i+2], data[i+3],
                                         data[i+4:i+132]))
        i += 132		
    return points

def getMatchLocations(matches):
    """Reduce keypoints to their locations"""
    matchLocations = []
    for k0, k1 in matches:
        matchLocations.append(k0.location+k1.location)
    return matchLocations

def getImageMatches(imageName0, imageName1, ratio):
    """Get matches between two images at a given ratio"""
    extractSIFTFeatures(imageName0)
    extractSIFTFeatures(imageName1)
    return getMatchLocations(matchKeypointFiles(imageName0+".keys", imageName1+".keys", ratio))
    
    


