/*
 * David Fouhey
 * Keypoint Matcher
 *
 * Copyright (c) 2011, David F. Fouhey
 * See ../License.txt
 */

/* How many floats do we skip before the keys? In the case of SIFT, this is the
 * number of keys and their dimension.*/
#define INIT_SKIP 2
/* How many floats do we skip at the beginning of each key? In the case of SIFT
 * this is x, y, scale, and orientation */
#define PER_KEY_SKIP 4

#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[]){
    int key0Count, key1Count, keyLength, i, j, si, key1Index;
    /* The list 1 keys */
    float **keys0, *key; 
    float sensitivity, dummy; 
    if(argc != 5){
        fprintf(stderr,"\n%s <key length> <number in 1st key list> <number in 2nd key list> <distRatio>\n\n", argv[0]);
        fprintf(stderr,"    Performs a matching between two lists of feature descriptors. This expects the\n");
        fprintf(stderr,"feature descriptors to be given in standard in, separated by whitespace,\n");
        fprintf(stderr,"simply written out one number after another, with no delineators, with the\n");
        fprintf(stderr,"first list written, then the second (again with no delineators). It performs\n");
        fprintf(stderr,"matches from the second list against the first.\n");
        fprintf(stderr,"\n    distRatio is the cut off. Feature f0 and f1 are considered to match if\n");
        fprintf(stderr,"d(f0,f1) < d(fsnn,f1)*distRatio where fsnn is the next nearest neighbor\n");
        fprintf(stderr,"to f1 in feature descriptor list 0.\n");
        return 1;
    }
    /* Get the input controls */ 
    keyLength = atoi(argv[1]);
    key0Count = atoi(argv[2]);
    key1Count = atoi(argv[3]);
    sensitivity = atof(argv[4]);
    for(si = 0; si < INIT_SKIP; si++){
        scanf("%f", &dummy);
    }

    keys0 = malloc(sizeof(float *)*key0Count);
    for(i = 0; i < key0Count; i++){
        for(si = 0; si < PER_KEY_SKIP; si++){
            scanf("%f", &dummy);
        }
        /* for each key in the 1st list */
        keys0[i] = malloc(sizeof(float)*keyLength);
        for(j = 0; j < keyLength; j++){
            fscanf(stdin,"%f",&(keys0[i][j]));
        }
    }

    for(si = 0; si < INIT_SKIP; si++){
        scanf("%f", &dummy);
    }

    key = malloc(sizeof(float)*keyLength);
    for(key1Index = 0; key1Index < key1Count; key1Index++){
        int matches[2];
        float matchDists[2];
        int k;
        for(si = 0; si < PER_KEY_SKIP; si++){
            scanf("%f", &dummy);
        }
        for(j = 0; j < keyLength; j++){
            fscanf(stdin,"%f",&(key[j]));
        }
        matches[0] = -1;
        matches[1] = -1;
        matchDists[0] = 1e20;
        matchDists[1] = 1e20;
        /* now match the key */
        for(j = 0; j < key0Count; j++){
            float dist = 0;
            /* find the distance in feature space */
            for(k = 0; k < keyLength; k++){
                float d = (keys0[j][k]-key[k]);
                dist += d*d;
            }
            if(dist < matchDists[0]){
                matches[1] = matches[0];
                matchDists[1] = matchDists[0];
                matches[0] = j;
                matchDists[0] = dist;
            } else if(dist < matchDists[1]){
                matches[1] = j;
                matchDists[1] = dist;
            }
        }
        if(matchDists[0] < matchDists[1]*sensitivity*sensitivity){
            fprintf(stdout,"%d %d\n",matches[0],key1Index);
        }
    }
    return 0;
}
