#!/usr/bin/python
##################################################
#Copyright (c) 2011, David F. Fouhey
#See License.txt
##################################################
#Homography Computation Code 
##################################################

import numpy
from common import *

#Solution from here: http://alumni.media.mit.edu/~cwren/interpolator/
def solvePerspective(matches):
    """Return the 3x3 transformation matrix giving the least squares or exact solution for
    the perspective transformation of the given points (looking up correspondences using the match
    member of Point2D)."""
    m = []
    bL = []
    for x, y, xp, yp in matches:
        #x,y is point0, X,Y is the corresponding point, point1
        m.append([x, y, 1, 0, 0, 0, -xp*x, -xp*y])
        m.append([0, 0, 0, x, y, 1, -yp*x, -yp*y])
        bL.append([xp])
        bL.append([yp])
    A = numpy.matrix(m)
    b = numpy.matrix(bL)
    solution = None
    if len(m) == 4:
        solution = map(float, numpy.linalg.solve(A,b))
    else:
        solution = map(float, numpy.linalg.lstsq(A,b)[0])
    return [ [ solution[0], solution[1], solution[2] ], [ solution[3], solution[4], solution[5] ], [solution[6], solution[7], 1.0 ] ] 

def project(H, p):
    """Project a point p with a homography H"""
    x, y = p
    xpw = H[0][0]*x + H[0][1]*y + H[0][2]
    ypw = H[1][0]*x + H[1][1]*y + H[1][2]
    w = H[2][0]*x + H[2][1]*y + H[2][2]
    return (xpw/w, ypw/w)

def getError(H, match):
    """Get the error of a match under a given homography"""
    x, y, xp, yp = match
    xh, yh = project(H, (x,y))
    return ED((xh, yh), (xp,yp))

