#!/usr/bin/python
##################################################
#Copyright (c) 2011, David F. Fouhey
#See License.txt
##################################################
#Robust Fitting Code
##################################################


from common import *
from homography import *

thresholds = [20, 15, 12, 10, 8, 6, 5, 4, 3, 2, 1.5]

def RobustFit(model, matches):
    currentMatches = matches
    currentModel = [[1.0, 0.0, 0,0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]]
    for thresh in filters:
        if len(currentMatches) < 4:
            break
        currentModel = solvePerspective(currentMatches)
        currentMatches = [m for m in currentMatches if getError(currentModel, m) < thresh]
    return (currentMatches, currentModel)
    


