#!/usr/bin/python
##################################################
#Copyright (c) 2011, David F. Fouhey
#See License.txt
##################################################
#Global Merging Code
##################################################


from homography import *
from math import *
from random import *

def mergingDistance(cluster1, cluster2):
    """Compute the merging distance: the average error of the union of the 
    clusters under their least-squares model"""
    #compute the union of the clusters
    clusterUnion = cluster1+cluster2

    #compute the best-fit homography
    Hhat = solvePerspective(clusterUnion)
    
    #compute the average error
    errors = [getError(Hhat, m) for m in clusterUnion]
    return sum(errors) / len(errors)
    

def globalMerging(clusters, epsilon):
    """Merge the clusters"""

    validIndices = range(len(clusters))
    distances = {}
    for ii, i in enumerate(validIndices):
        for j in validIndices[ii+1:]:
            distances[(i,j)] = -1

    while True:
        minDistance = 10*epsilon
        minPair = (-1, -1)
        for ii, i in enumerate(validIndices):
            for j in validIndices[ii+1:]:
                #if not valid, update
                if distances[(i,j)] < 0:
                    distances[(i,j)] = mergingDistance(clusters[i], clusters[j])

                #update the minimum distance
                if distances[(i,j)] < minDistance:
                    minPair = i,j
                    minDistance = distances[(i,j)]

        if minDistance > epsilon:
            break

        #update the distances
        clusters[minPair[0]] += clusters[minPair[1]]
        validIndices.remove(minPair[1])

        #mark the distances as invalid
        for i in validIndices:
            distances[(minPair[0],i)] = distances[(i,minPair[0])] = -1
    
    return [clusters[i] for i in validIndices]
    
    


