function collateMinePosThresh()
globals;

procDir = PROCESSING_DIR;
inputDir = [procDir 'posThreshMineDir2/'];
outputDir = [procDir 'posThreshAdded6/'];
detectorDir = [procDir 'posThreshAdded5/'];
if ~exist(outputDir, 'dir')
  mkdir(outputDir);
end

% Load processing data
fprintf('Loading data ...  ');
load([procDir 'ALL_DATA']);
load([HCONDATA 'sun09_objectCategories.mat']);
load([HCONDATA 'sun09_groundTruth.mat']);
fprintf('done\n');
primaryCat = 'bed';
secondaryCat = 'person'; % Dummy category  
fprintf('Making Selection... ');
[wPSTe wPnSTe wnPSTe wnPnSTe] = makeSelection(Dtraining, ...
  primaryCat, secondaryCat, false);
fprintf('done\n');
testSetPos = [wPSTe wPnSTe];
clear wPSTe wPnSTe wnPSTe wnPnSTe;

% Load detection result data
detectionResultDir = [PROCESSING_DIR 'detectionResultPosThreshTrain5/'];
if exist(detectionResultDir, 'dir')
  load([detectionResultDir 'all_detections']);
else
  ratios = ones(size(selectedClusters)) * Inf;
end

% Load detectors.
fprintf('Loading detectors ...  ');
[models, results] = loadDetectorModels(detectorDir, selectedClusters);
fprintf('done\n');

inSuffix = 'posthresh';
decisionScores = cell(1, length(selectedClusters));
for i = 1 : length(testSetPos)
  fileName = [inputDir sprintf('%d_', i) inSuffix '.mat'];
  load(fileName);
  for j = 1 : length(detResults.detections)
    if ~isempty(detResults.detections(j).metadata)
      decisionScores{j} = [decisionScores{j} ...
        detResults.detections(j).decision];
    end
  end
end

outSuffix = 'det';
selectedNumIncrement = 5;
for i = 1 : length(decisionScores)
  scores = sort(decisionScores{i}, 'descend');
   
  if isinf(ratios(i))
    if isfield(models{i}, 'info') && isfield(models{i}.info, 'numToSelect')
      numToSelect = min(length(scores), models{i}.info.numPositives + ...
        models{i}.info.numToSelect + selectedNumIncrement);
      models{i}.info.numToSelect = models{i}.info.numToSelect + ...
        selectedNumIncrement;
    else
      numToSelect = min(length(scores), models{i}.info.numPositives + ...
        detectionParams.numToSelect);
      models{i}.info.numToSelect = detectionParams.numToSelect;
    end
    models{i}.threshold = scores(numToSelect);
  end
  clustId = selectedClusters(i);
  model = models{i};
  result = results{i};
  save([outputDir sprintf('%d_', clustId) outSuffix '.mat'], 'model', ...
      'result');
end
end
