function warpMinePosThresh(instanceId)
globals;

% Initialize instance some variables
rand('twister', instanceId);
pause(rand(1,1)*10);
procDir = PROCESSING_DIR;
inputDir = [procDir 'retrainOutputDir3/'];
outputDir = [procDir 'posThreshMineDir2/'];
if ~exist(outputDir, 'dir')
  mkdir(outputDir);
end

% Load processing data
load([procDir 'ALL_DATA']);

% Load processing data
fprintf('Loading data ...  ');
load([HCONDATA 'sun09_objectCategories.mat']);
load([HCONDATA 'sun09_groundTruth.mat']);
fprintf('done\n');
primaryCat = 'bed';
secondaryCat = 'person'; % Dummy category  
fprintf('Making Selection... ');
[wPSTe wPnSTe wnPSTe wnPnSTe] = makeSelection(Dtraining, ...
  primaryCat, secondaryCat, false);
fprintf('done\n');
testSetPos = [wPSTe wPnSTe];
clear wPSTe wPnSTe wnPSTe wnPnSTe;

% Load detectors.
fprintf('Loading detectors ...  ');
models = cell(1, length(selectedClusters));
for i = 1 : length(selectedClusters)
  clustId = selectedClusters(i);
  load([inputDir sprintf('%d_det.mat', clustId)], 'model');
  models{i} = model;
end

% Initialize the detection parameters.
detectionParams = struct( ...
  'selectTopN', true, ...
  'numToSelect', 10, ...
  'useDecisionThresh', false, ...
  'overlap', params.overlapThreshold);

% Start processing the images
outSuffix = 'posthresh';
processImages(testSetPos, models, params, instanceId, outputDir, ...
  outSuffix, HOMEIMAGES, detectionParams);
disp('Done Processing Everything');
end

function processImages(data, models, params, instanceId, outputDir, ...
  outSuffix, imgHome, detectionParams)
randInds = randperm(length(data));
for i = 1 : length(randInds)
  imgId = randInds(i);
  fprintf('Processing image %d\n', imgId);
  if isClusterStillUnprocessed(instanceId, imgId, outputDir, outSuffix)
    detResults = detectPresence(data(imgId), models, params, imgHome, ...
      false, detectionParams);
    save([outputDir sprintf('%d_', imgId) outSuffix '.mat'], ...
      'detResults', 'detectionParams');
    doneClusterProcessing(imgId, outputDir);
  end
  fprintf('Done processing image %d\n', imgId);
end
end
