function top_100_masked(all, boxes1Cond, numTop, gmm, ...
    primaryCat, threshPercent)
% Author: saurabh.me@gmail.com (Saurabh Singh)

configure;
condMaxImgs = zeros(length(all));

for i  = 1 : length(all)
  cboxes = boxes1Cond{i};
  if ~isempty(cboxes)
    condMaxImgs(i) = max(cboxes(:, end));
  else
    condMaxImgs(i) = -1000;
  end
end

[~, cmaxInds] = sort(condMaxImgs, 'descend');

selCondInds = cmaxInds(1:numTop);
selCond = all(selCondInds);

for i = 1 : length(selCond)
  img1Path = [HOMEIMAGES selCond(i).annotation.folder '/' ...
      selCond(i).annotation.filename];
  imCond = im2double(imread(img1Path));
  mask = getHighProbMask(imCond, selCond(i).annotation, gmm, ...
      threshPercent, primaryCat);
  mask(mask<0) = 0;
  mask = mask ./ max(max(mask));
  imCond(:, :, 1) = imCond(:, :, 1) .* mask;
  imCond(:, :, 2) = imCond(:, :, 2) .* mask;
  imCond(:, :, 3) = imCond(:, :, 3) .* mask;
  
  fig1 = figure(1); clf;
  myshowboxes(imCond, boxes1Cond{selCondInds(i)}, 5);
  fig3 = figure(3); clf;
  LMplot(selCond(i), 1, HOMEIMAGES); title('Ground Truth');
  
  print(fig1, '-djpeg', '-r0', ...
      sprintf('top100/masked/%d_cond_mask.jpg', i));
  print(fig3, '-djpeg', '-r0', ...
      sprintf('top100/masked/%d_gtht.jpg', i));
end
