function pick = myNmsPascal(boxes, overlap)
% top = nms_fast(boxes, overlap)
% Non-maximum suppression. (FAST VERSION)
% Greedily select high-scoring detections and skip detections
% that are significantly covered by a previously selected
% detection.
% NOTE: This is adapted from Pedro Felzenszwalb's version (nms.m),
% but an inner loop has been eliminated to significantly speed it
% up in the case of a large number of boxes
% Tomasz Maliseiwicz (tomasz@cmu.edu)

if isempty(boxes)
  pick = [];
  return;
end

s = boxes(:,end);

[vals, I] = sort(s);

pick = s*0;
counter = 1;
while ~isempty(I)
  
  last = length(I);
  i = I(last);  
  pick(counter) = i;
  counter = counter + 1;
  
  o = computeOverlap(boxes(I(1:last-1), :), boxes(i, :), 'pascal');
  I([last; find(o>overlap)]) = [];
end

pick = pick(1:(counter-1));
% top = boxes(pick,:);
