function generateHtmlPageWithTable(data, filePath)
% Data is a cell array of cell arrays.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

file = fopen(filePath, 'w');
writeHeader(file);
startTable(file);
for i = 1 : length(data)
  startRow(file);
  for j = 1 : length(data{i})
    writeCell(file, data{i}{j});
  end
  endRow(file);
end
endTable(file);
writeFooter(file);
fclose(file);
end

function writeHeader(file)
fprintf(file, '<html><body>');
end

function writeFooter(file)
fprintf(file, '</body></html>');
end

function startTable(file)
fprintf(file, '<table border="1">\n');
end

function endTable(file)
fprintf(file, '</table>\n');
end

function startRow(file)
fprintf(file, '<tr>\n');
end

function endRow(file)
fprintf(file, '</tr>\n');
end

function writeCell(file, strData)
fprintf(file, '<td>%s</td>\n', strData);
end
