function [boxes1, boxes2] = pedro4ModifiedTest(model, testData, imgHome)
% [boxes1, boxes2] = pascal_test(cls, model, testset, suffix)
% Compute bounding boxes in a test set.
% boxes1 are bounding boxes from root placements
% boxes2 are bounding boxes using predictor function

% We will set the threshold lower to get more detections.
% model.thresh = model.thresh - 0.01;

boxes1 = cell(size(testData));
boxes2 = cell(size(testData));
for i = 1 : length(testData)
  fprintf('%d\n', i);
  imgPath = [imgHome testData(i).annotation.folder '/' ...
    testData(i).annotation.filename];
  [b1, b2] = getBoxes(imgPath, model);
  boxes1{i} = b1;
  boxes2{i} = b2;
  %myshowboxes(imread(imgPath), boxes1{i}, boxCount);
end
end

function [boxes1, parts1] = getBoxes(imgPath, model)
im = imread(imgPath);
[dets, boxes] = imgdetect(im, model, model.thresh);
if ~isempty(boxes)
  boxes = reduceboxes(model, boxes);
  [dets boxes] = clipboxes(im, dets, boxes);
  % No NMS at this point.
  % I = nms(dets, 0.5);
  I = (1 : size(dets, 1))';
  
  boxes1 = dets(I,[1:4 end]);
  parts1 = boxes(I,:);
else
  boxes1 = [];
  parts1 = [];
end
end
