function [b1trfor, b2trfor] = transformWithBox1AsCano(box1, box2)
% Transforms the boxes such that box1 are all centered at origin, and have
% unit dimensions.
sc1 = box1(:, 3) - box1(:, 1);
b1trfor = box1(:, 1:4) ./ repmat(sc1, 1, 4);
meb1trfor = [mean(b1trfor(:, [1 3]), 2) mean(b1trfor(:, [2 4]), 2)];
b1trfor = b1trfor - repmat(meb1trfor, 1, 2);
b1trfor(:, 5) = 0;
b2trfor = box2(:, 1:4) ./ repmat(sc1, 1, 4);
b2trfor = b2trfor - repmat(meb1trfor, 1, 2);
b2trfor(:, 5) = 0;
end
