function [posPatch, posFeats, corrImgs] = ...
  getRandomPatchesFromPyramidWhiteout(pos, posIds, params, homeImgs, ...
  maskDir, minOverlap)
% Gets random patches from a set of images.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

posPatchesPerImg = cell(1, length(pos));
posFeatsPerImg = cell(1, length(pos));
totalPatches = 0;
pBar = createProgressBar();
for i = 1 : length(pos)
  pBar(i, length(pos));
  
  retries = 2;
  picks = [];
  while isempty(picks) && retries > 0
    [pats, feats, unused] = sampleRandomPatches(pos(i), homeImgs, params);
    retries = retries - 1;
    bx = getBoxesForPedro(pats);
    fileName = [maskDir sprintf('%d.mat', posIds(i))];
    maskBoxes = load(fileName, 'boxes');
    oldBoxes = maskBoxes.boxes;
    overlaps = computeOverlap(bx, oldBoxes, 'pedro');
    mostOverlap = max(overlaps, [], 2);
    picks = find(mostOverlap >= minOverlap);
  end
  posPatchesPerImg{i} = pats(picks);
  posFeatsPerImg{i} = feats(picks, :);
  totalPatches = totalPatches + length(posPatchesPerImg{i});
end
fprintf('Appending all patches together ...\n');
[posFeats, posPatch, indexes] = appendPatchDataTogether(posFeatsPerImg, ...
  posPatchesPerImg, totalPatches);
corrImgs = indexes(:, 1);
fprintf('Total patches: %d\n', totalPatches);
end
