function [selTriplet, hiloBit] = getClusterTriplets(ho, selectedClusters)

hopa = triu(ho, 1);
[ci, cj] = find(hopa);
selTriplet = zeros(length(selectedClusters) * length(ci), 3);
hiloBit = zeros(length(selectedClusters) * length(ci), 3);
selTInd = 0;
pBar = createProgressBar();
for i = 1 : length(ci)
  pBar(i, length(ci));
  for j = max(ci(i), cj(i)) + 1 : length(selectedClusters)
    if j ~= ci(i) && j ~= cj(i)
      if (ho(ci(i), j) + ho(cj(i), j)) == 1
        selTInd = selTInd + 1;
        selTriplet(selTInd, :) = [ci(i) cj(i) j];
        hiloBit(selTInd, :) = [1 ho(ci(i), j) ho(cj(i), j)];
      end
    end
  end
end
selTriplet = selTriplet(1:selTInd, :);
hiloBit = hiloBit(1:selTInd, :);
end
