function [pairRel, pairC1Sc, pairIm] = generatePatchesPairPlot(saveDir, ...
  pairRelation, pairC1Scores, pairImgs, patMos1, patMos2, selPair)

mkdir(saveDir);
pairRel = cell2mat(pairRelation(selPair));
pairC1Sc = cell2mat(pairC1Scores(selPair));
pairIm = cell2mat(pairImgs(selPair));
medianPairRel = median(pairRel);
% fig = figure(1);
% clf;
subplot(2, 3, 1);
imshow(patMos1);
subplot(2, 3, 4);
imshow(patMos2);
for h = 1 : size(pairRel, 1)
  subplot(2, 3, 2);
  hold on;
  axis equal;
  set(gca, 'YDir', 'Reverse');
  line([0 pairRel(h, 1)], [0 pairRel(h, 2)]);
  line([0 medianPairRel(1)], [0 medianPairRel(2)], 'Color', 'r', ...
    'LineWidth', 4);
  
  subplot(2, 3, 3);
  hold on;
  axis equal;
  set(gca, 'YDir', 'Reverse');
  line([0 pairRel(h, 1)], [0 pairRel(h, 3)]);
  line([0 medianPairRel(1)], [0 medianPairRel(3)], 'Color', 'r', ...
    'LineWidth', 4);
  
  subplot(2, 3, 5);
  hold on;
  axis equal;
  set(gca, 'YDir', 'Reverse');
  line([0 pairRel(h, 2)], [0 pairRel(h, 3)]);
  line([0 medianPairRel(2)], [0 medianPairRel(3)], 'Color', 'r', ...
    'LineWidth', 4);
end
% saveas(fig, [saveDir getDateBasedFilePrefix() '.jpg'], 'jpg');
end
