function mosaic = constructPerIterPatMosaic(perIterPats, ...
  maxPerIterPats, canonicalSize, horizontal)

patImgs = getPatches(perIterPats, maxPerIterPats, canonicalSize);
if horizontal
  mosaic = cell2mat(patImgs);
else
  mosaic = cell2mat(patImgs');
end
% keyboard;
end

function patImgs = getPatches(perIterPats, maxPerIterPats, canoSize)
paddingSize = 4;
patImgs = cell(length(perIterPats), maxPerIterPats);
for i = 1 : length(perIterPats)
  for j = 1 : maxPerIterPats
    if length(perIterPats{i}) < j
      p = ones(size(p));
    else
      p = getPatchFromImage(perIterPats{i}(j), canoSize);
      if size(p, 3) < 3
        p = repmat(p, [1, 1, 3]);
      end
      p = padPatchImages(p, paddingSize);
    end
    patImgs{i, j} = p;
  end
end
end

function pat = getPatchFromImage(patch, canonicalSize)
D = patch;
I = im2double(imread(D.im));
if D.flip
  I(:,:,1) = fliplr(I(:,:,1));
  I(:,:,2) = fliplr(I(:,:,2));
  I(:,:,3) = fliplr(I(:,:,3));
end

I = getSubImg(I, D);
pat = imresize(I, canonicalSize, 'bilinear');
end
