function [relLoc, c1Sc, imgs] = computeCanonicalRelativeLocations(cl1, ...
  cl2, imgSet, c1NmsThresh, detResDir)
% Computes the location of cl2 relative to cl1 from the given data.

results = PresenceDetectionResults(detResDir);
pairRelation = cell(2 * length(imgSet), 1);
pairC1Scores = cell(2 * length(imgSet), 1);
pairImgs = cell(2 * length(imgSet), 1);
pairInd = 0;
pBar = createProgressBar();
for i = 1 : length(imgSet)
  pBar(i, length(imgSet));
  rs = results.getPosResult(imgSet(i));
  d1 = rs.firstLevel.detections(cl1);
  d1 = doNmsForCl1(d1, c1NmsThresh);
  d2 = rs.firstLevel.detections(cl2);
  if ~isempty(d1.metadata) && ~isempty(d2.metadata)
    b1 = getBoxesForPedro(d1.metadata);
    b2 = getBoxesForPedro(d2.metadata);
    sc1 = b1(:, 3) - b1(:, 1);
    sc2 = b2(:, 3) - b2(:, 1);
    for j = 1 : size(b1, 1)
      b1t = repmat(b1(j, :), size(b2, 1), 1);
      sc1t = ones(size(b2, 1), 1) * sc1(j);
      [b1trfor, b2trfor] = transformWithBox1AsCano(b1t, b2);
      metrfor = [mean(b2trfor(:, [1 3]), 2) mean(b2trfor(:, [2 4]), 2)];
      fe = [metrfor sc2 ./ sc1t];
      pairInd = pairInd + 1;
      pairC1Scores{pairInd} = ones(size(fe, 1), 1) * d1.decision(j);
      pairImgs{pairInd} = ones(size(fe, 1), 1) * imgSet(i);
      pairRelation{pairInd} = fe;
    end
%     keyboard;
  end
end

relLoc = pairRelation(1 : pairInd);
c1Sc = pairC1Scores(1 : pairInd);
imgs = pairImgs(1 : pairInd);
end


function nmsD = doNmsForCl1(d, thresh)
nmsD = d;
picks = doNmsForImg(d.metadata, d.decision, thresh);
nmsD.metadata = d.metadata(picks);
nmsD.decision = d.decision(picks);
end
