% Set up global variables used throughout the code
configure;

%where the rgb images are
trainBase = '../setupDataset/dataset/canonicalSplits/';
%the natural world images
natWorldBase = '../NaturalData/';
%where the surface normals are
normalBase = '../setupDataset/dataset/normals/';
%where the depth data is
depthBase = '../setupDataset/dataset/depth/';
%this is where the patches get stored
processingDir = '../processing/';

%note the lack of / in processingName -- we append various things to
%this name.
processingName = 'NYUTDP';

%number of back-and-forth iterations (i.e., one round of iterations updating
%all the variables). 
%1 should give reasonable performance; if you can spare the time, setting
%it to 3 boosts performance a reasonable amount
numIterations = 1;

%the location of the final patches
patchesTarget = '../tdp/';


%%%These get all set automatically%%%
CONFIG.NYUDir = [trainBase '/trainTrain/'];
CONFIG.NYUHNDir = [trainBase '/trainHN/'];
CONFIG.hayes6MillDataDir = natWorldBase;
CONFIG.processingDir = processingDir;
CONFIG.hayes6MillImgHome = natWorldBase;
CONFIG.libHome = libHome;
CONFIG.normals = normalBase;
CONFIG.normalSource = normalBase;
CONFIG.depthSource = depthBase;
CONFIG.processingName = processingName;
CONFIG.iterCut = 2*(numIterations-1);
CONFIG.trainTrain = [trainBase '/trainTrain/'];
CONFIG.rawSource = [processingDir '/' processingName '_1/'];
CONFIG.processedSource = patchesTarget;
CONFIG.detectorCode = './';


