function feats = getShapeAppearanceFeatures(imgs, category)
globals;
homeImgs = HOMEIMAGES;
feats = zeros(length(imgs), 8);
parfor i = 1 : length(imgs)
  feats(i, :) = getFeat(imgs(i), category, homeImgs);
end
feats = postProcessFeat(feats);
end

function ft = getFeat(imgs, category, homeImgs)
[msk, ~] = LMobjectmask(imgs.annotation, homeImgs, category);
[rows, cols, ~] = size(msk);
msk = msk(:, :, 1);
stats = regionprops(msk, 'all');
selStat = 0;
maxStatArea = 0;
for i = 1 : length(stats)
  if stats(i).Area > maxStatArea
    maxStatArea = stats(i).Area;
    selStat = i;
  end
end
stats = stats(selStat);
maxArea = rows * cols;
maxLen = norm([rows cols]);
maxPerimeter = maxArea;
aArea = stats.Area / maxArea;
peri = stats.Perimeter / maxPerimeter;
convArea = stats.Area / stats.ConvexArea;
majorAxis = stats.MajorAxisLength / maxLen;
minorAxis = stats.MinorAxisLength / maxLen;
ecc = stats.Eccentricity;
[bbr bbc] = size(stats.Image);
aspect = bbc / bbr;
ratArPer = stats.Area / stats.Perimeter^2;
ft = [aArea peri convArea majorAxis minorAxis ecc aspect ratArPer];
end

function feat = postProcessFeat(features)
if min(min(features)) < 0
  error('Feature values cant be less than zero');
end
feat = zeros(size(features));
for i = 1 : size(features, 2)
  a = features(:, i);
  a = a - min(a);
  a = a / max(a);
  feat(:, i) = a;
end
end