function sumDist = getSumScaleDistNonPara(rows, cols, gmm, patches)
% Generates a distribution centered at the patch. 
sizeBins = 0 : 10 : rows;
  
probs = zeros(size(sizeBins));
for i = 1 : length(patches)
  vertExt = getVerticalExtent(patches(i));
  sizeVals = sizeBins ./ vertExt;
  probs = probs + pdf(gmm, sizeVals);    
end
sumDist = probs;
end

function [cx cy] = getCenter(data)
cx = (data.x1 + data.x2) / 2;
cy = (data.y1 + data.y2) / 2;
end

function ext = getVerticalExtent(data)
ext = abs(data.y2 - data.y1);
end
