function [trainLabels, testLabels] = getTrainTestLabels(categories, allData)
trainLabels = cell(size(categories));
for i = 1 : length(categories)
  trainLabels{i} = arrayfun(@(x) ismember({categories{i}}, ...
    {x.annotation.object.name}), allData.trainPosData);

  trainLabels{i} = trainLabels{i} * 2 - 1;
  trainLabels{i} = [trainLabels{i} -1*ones(size(allData.trainNegFileNames))]';
end

testLabels = cell(size(categories));
for i = 1 : length(categories)
  testLabels{i} = arrayfun(@(x) ismember({categories{i}}, ...
    {x.annotation.object.name}), allData.testPosData);

  testLabels{i} = testLabels{i} * 2 - 1;
  testLabels{i} = [testLabels{i} -1*ones(size(allData.testNegFileNames))]';
end
end
