function [voteMix, allMix] = getPerClusterVoteMix(clusterInformation, ...
  locationInfo)
% Gets the mixture or bag of votes for each cluster.
%
% voteMix: cell array of Nix4 elements. Where first four elements in the
%   ith row are (x, y, scale, aspect). Scale and aspect ratio are in
%   arctan.
% allMix: Nx4 array of all in voteMix.
%
% Author: saurabh.me@gmail.com (Saurabh Singh)

clustToProcess = clusterInformation.clustersToProcess;
patVoteLocs = getPatchVoteLocations(locationInfo);

voteMix = cell(1, length(clustToProcess));
allMix = [];
for j = 1 : length(clustToProcess)
  currClust = clustToProcess(j);
  toProcess = find(clusterInformation.assignedClusters==currClust);
  for i = 1 : length(toProcess)
    voteMix{j}{i} = patVoteLocs{toProcess(i)};
    allMix = [allMix; patVoteLocs{toProcess(i)}];
  end
end
end
