function box = convertLocationToBoxCoods(points, shouldRound)
% Converts the location space coods to the box coods.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

if ~exist('shouldRound', 'var')
  shouldRound = false;
end

box = zeros(size(points));
for i = 1 : size(points, 1)
  pth = points(i, 3);
  ptw = tan(points(i, 4) * (pi/2)) * pth;
  ptx2 = (2 * points(i, 1) + ptw - 1) / 2;
  ptx1 = ptx2 + 1 - ptw;
  pty2 = (2 * points(i, 2) + pth - 1) / 2;
  pty1 = pty2 + 1 - pth;
  box(i, 1:4) = [ptx1 pty1 ptx2 pty2];
end
if shouldRound
  box = round(box);
end
box(:, 5:end) = points(:, 5:end);
end
