function detectors = constructDetectorFromModels(trainDir, ...
  clusterInformation, locationInfo, params, suffix)
% Author: saurabh.me@gmail.com (Saurabh Singh)
globals;

[firstLev, unused, unused] = loadDetectorModels(trainDir, [], ...
  clusterInformation.clustersToProcess, suffix);
detectors = VisualEntityDetectors(firstLev, params);

if ~isempty(locationInfo)
  [voteMix, unused] = getPerClusterVoteMix( ...
    clusterInformation, locationInfo);
  voteDistribution = learnVoteDistribution(voteMix);
  detectors.setMixModel(voteDistribution);
end
end
