function displaySunImages(data, imgHome, groundTruth, shouldPause)
% Utility to display suns image annotations.
%
% Author: saurabh.me@gmail.com (Saurabh Singh)

if nargin < 4
  shouldPause = false;
end

for i = 1 : length(data)
  clf;
  if groundTruth
    LMplot(data, i, imgHome);
  else
    thisImg = data(i).annotation;
    imPath = [imgHome thisImg.folder '/' thisImg.filename];
    I = imread(imPath);
    imshow(I);
  end
  if shouldPause
    fprintf('%d Press any key to continue ...\n', i);
    pause;
  end
end
end
