function storeNextIterationDataTmp(topN, trainSetPos, validSetPos, ...
  validSetNeg, selectedClusters, nextIterDir, params)

[posFeatures, positivePatches, ...
    posCorrespInds, posCorrespImgs, assignedClustVote, ...
    assignedClustTrain, selectedClusters] = ...
    prepareDetectedPatchClusters(topN, ...
      5, 5, params, trainSetPos, selectedClusters);
assignedClust = assignedClustTrain;
centers = calculateClusterCenters(selectedClusters, assignedClust, ...
  posFeatures);

save([nextIterDir 'FIG_PATCH_CLUSTERS_REF'], 'assignedClust', ...
  'centers', 'params', 'selectedClusters', 'positivePatches', ...
  'posFeatures', 'posCorrespInds');
save([nextIterDir 'POS_CALC_FEATURES'], 'posFeatures', ...
  'positivePatches', 'posCorrespInds', 'posCorrespImgs', 'params');

debug.assignedClustVote = assignedClustVote;
debug.assignedClustTrain = assignedClustTrain;

saveInfoForWarpProcessing(nextIterDir, assignedClust, ...
  centers, selectedClusters, posFeatures, positivePatches, ...
  validSetPos, validSetNeg, params, debug);
end
