function voteConsist = collateVoteConsist(dataDir, detectionResultsDir)
load([detectionResultsDir 'trainingData'], 'trainingData');

[posFeats, posLabels, posImgIds, posPosNeg] = getFeats(dataDir, ...
  trainingData.pos, '_vc_pos.mat');
[negFeats, negLabels, negImgIds, negPosNeg] = getFeats(dataDir, ...
  trainingData.neg, '_vc_neg.mat');

voteConsist = cell(size(posFeats));
for i = 1 : length(posFeats)
  voteConsist{i}.features = [posFeats{i}; negFeats{i}];
  voteConsist{i}.labels = [posLabels{i}; negLabels{i}];
  voteConsist{i}.imgIds = [posImgIds{i}; negImgIds{i}];
  voteConsist{i}.posNeg = [posPosNeg{i}; negPosNeg{i}];
end

end


function [feats, labels, imgIds, posNeg] = getFeats(dataDir, imgs, suffix)
for i = 1 : length(imgs)
  id = imgs(i);
  try
    fileName = [dataDir sprintf('%d', id) suffix];
    load(fileName, 'voteConsist');
  catch
    fprintf('File not found: %s\n', fileName);
    continue;
  end
  if ~exist('feats', 'var')
    feats = cell(size(voteConsist));
    labels = cell(size(voteConsist));
    imgIds = cell(size(voteConsist));
    posNeg = cell(size(voteConsist));
  end
  
  for j = 1 : length(voteConsist)
    if isstruct(voteConsist{j})
      feats{j} = [feats{j}; voteConsist{j}.response];
      labels{j} = [labels{j}; voteConsist{j}.labels];
      imgIds{j} = [imgIds{j}; id * ones(size(voteConsist{j}.labels))];
      posNeg{j} = [posNeg{j}; voteConsist{j}.posNeg];
    end
  end
end
end
